/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.executors;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;

public final class ContextPropagatingRunnable
implements Runnable {
    private final Runnable delegate;
    private final Context context;

    public static boolean shouldDecorateRunnable(Runnable task) {
        return task.getClass().getName().contains("/") && !(task instanceof ContextPropagatingRunnable);
    }

    public static Runnable propagateContext(Runnable task, Context context) {
        return new ContextPropagatingRunnable(task, context);
    }

    private ContextPropagatingRunnable(Runnable delegate, Context context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public void run() {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.run();
        }
    }
}

