/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import java.util.Collections;
import java.util.List;

public final class HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();

    HttpClientAttributesExtractorBuilder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.netAttributesGetter = netAttributesGetter;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = requestHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = responseHeaders;
        return this;
    }

    public HttpClientAttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpClientAttributesExtractor<REQUEST, RESPONSE>(this.httpAttributesGetter, this.netAttributesGetter, this.capturedRequestHeaders, this.capturedResponseHeaders);
    }
}

