/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.TimeExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends RequestListener> requestListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    @Nullable
    private final TimeExtractor<REQUEST, RESPONSE> timeExtractor;
    private final boolean enabled;
    private final SpanSuppressionStrategy spanSuppressionStrategy;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    @Deprecated
    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, String instrumentationVersion, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return Instrumenter.builder(openTelemetry, instrumentationName, spanNameExtractor).setInstrumentationVersion(instrumentationVersion);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.requestListeners = builder.buildRequestListeners();
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.timeExtractor = builder.timeExtractor;
        this.enabled = builder.enabled;
        this.spanSuppressionStrategy = builder.buildSpanSuppressionStrategy();
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (!this.enabled) {
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressionStrategy.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    /*
     * WARNING - void declaration
     */
    public Context start(Context parentContext, REQUEST request) {
        void var9_16;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        Instant startTime = null;
        if (this.timeExtractor != null) {
            startTime = this.timeExtractor.extractStartTime(request);
            spanBuilder.setStartTimestamp(startTime);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        UnsafeAttributes attributesBuilder = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributesBuilder, parentContext, request);
        }
        UnsafeAttributes unsafeAttributes = attributesBuilder;
        Context context = parentContext;
        spanBuilder.setAllAttributes(unsafeAttributes);
        Span span = spanBuilder.startSpan();
        Context context2 = context.with(span);
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            void var9_14;
            Context context3 = contextCustomizer.start((Context)var9_14, request, unsafeAttributes);
        }
        if (!this.requestListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (RequestListener requestListener : this.requestListeners) {
                Context context4 = requestListener.start((Context)var9_16, unsafeAttributes, startNanos);
            }
        }
        return this.spanSuppressionStrategy.storeInContext((Context)var9_16, spanKind, span);
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCode;
        Span span = Span.fromContext(context);
        if (error != null) {
            error = this.errorCauseExtractor.extractCause(error);
            span.recordException(error);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributes, context, request, response, error);
        }
        span.setAllAttributes(attributes);
        Instant endTime = null;
        if (this.timeExtractor != null) {
            endTime = this.timeExtractor.extractEndTime(request, response, error);
        }
        if (!this.requestListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            ListIterator<? extends RequestListener> i = this.requestListeners.listIterator(this.requestListeners.size());
            while (i.hasPrevious()) {
                i.previous().end(context, attributes, endNanos);
            }
        }
        if ((statusCode = this.spanStatusExtractor.extract(request, response, error)) != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
        if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }
}

