/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public abstract class NetClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    @Override
    public final void onStart(AttributesBuilder attributes, REQUEST request) {
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.set(attributes, SemanticAttributes.NET_TRANSPORT, this.transport(request, response));
        String peerIp = this.peerIp(request, response);
        String peerName = this.peerName(request, response);
        if (peerName != null && !peerName.equals(peerIp)) {
            this.set(attributes, SemanticAttributes.NET_PEER_NAME, peerName);
        }
        this.set(attributes, SemanticAttributes.NET_PEER_IP, peerIp);
        Integer peerPort = this.peerPort(request, response);
        if (peerPort != null && peerPort > 0) {
            this.set(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
        }
    }

    @Nullable
    public abstract String transport(REQUEST var1, @Nullable RESPONSE var2);

    @Nullable
    public abstract String peerName(REQUEST var1, @Nullable RESPONSE var2);

    @Nullable
    public abstract Integer peerPort(REQUEST var1, @Nullable RESPONSE var2);

    @Nullable
    public abstract String peerIp(REQUEST var1, @Nullable RESPONSE var2);
}

