/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class HttpServerMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("http-server-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(HttpServerMetrics.class);
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;

    @UnstableApi
    public static RequestMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("requests").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = meter.histogramBuilder("http.server.duration").setUnit("ms").setDescription("The duration of the inbound HTTP request").build();
    }

    @Override
    public Context start(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, TemporaryMetricsView.applyActiveRequestsView(startAttributes), context);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void end(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot reset HTTP request metrics.", (Object)context);
            return;
        }
        this.activeRequests.add(-1L, TemporaryMetricsView.applyActiveRequestsView(state.startAttributes()));
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, TemporaryMetricsView.applyServerDurationView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

