/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.AutoValue_RpcClientMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.MetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class RpcClientMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("rpc-client-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(RpcClientMetrics.class);
    private final DoubleHistogram clientDurationHistogram;

    private RpcClientMetrics(Meter meter) {
        this.clientDurationHistogram = meter.histogramBuilder("rpc.client.duration").setDescription("The duration of an outbound RPC invocation").setUnit("ms").build();
    }

    @UnstableApi
    public static RequestMetrics get() {
        return RpcClientMetrics::new;
    }

    @Override
    public Context start(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_CLIENT_REQUEST_METRICS_STATE, new AutoValue_RpcClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void end(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(RPC_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot record RPC request metrics.", (Object)context);
            return;
        }
        this.clientDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, MetricsView.applyClientView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

