/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.AutoValue_Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.CollectionParsers;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.NamingConvention;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Config DEFAULT;
    private static volatile Config INSTANCE;

    public static void internalInitializeConfig(Config config) {
        if (INSTANCE != DEFAULT) {
            log.warn("Config#INSTANCE was already set earlier");
            return;
        }
        INSTANCE = Objects.requireNonNull(config);
    }

    public static Config get() {
        return INSTANCE;
    }

    public static Config create(Map<String, String> allProperties) {
        return new AutoValue_Config(allProperties);
    }

    abstract Map<String, String> getAllProperties();

    public @Nullable String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        return this.getAllProperties().getOrDefault(NamingConvention.DOT.normalize(name), defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getTypedProperty(name, Boolean::parseBoolean, defaultValue);
    }

    public List<String> getListProperty(String name) {
        return this.getListProperty(name, Collections.emptyList());
    }

    public List<String> getListProperty(String name, List<String> defaultValue) {
        return this.getTypedProperty(name, CollectionParsers::parseList, defaultValue);
    }

    public Map<String, String> getMapProperty(String name) {
        return this.getTypedProperty(name, CollectionParsers::parseMap, Collections.emptyMap());
    }

    private <T> T getTypedProperty(String name, Function<String, T> parser, T defaultValue) {
        String value = this.getProperty(name);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return parser.apply(value);
        }
        catch (Throwable t) {
            log.debug("Cannot parse {}", (Object)value, (Object)t);
            return defaultValue;
        }
    }

    public boolean isInstrumentationEnabled(Iterable<String> instrumentationNames, boolean defaultEnabled) {
        return this.isInstrumentationPropertyEnabled(instrumentationNames, "enabled", defaultEnabled);
    }

    public boolean isInstrumentationPropertyEnabled(Iterable<String> instrumentationNames, String suffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : instrumentationNames) {
            String propertyName = "otel.instrumentation." + name + '.' + suffix;
            boolean enabled = this.getBooleanProperty(propertyName, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= enabled;
                continue;
            }
            anyEnabled |= enabled;
        }
        return anyEnabled;
    }

    public Properties asJavaProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getAllProperties());
        return properties;
    }

    public boolean isAgentDebugEnabled() {
        return this.getBooleanProperty("otel.javaagent.debug", false);
    }

    static {
        INSTANCE = DEFAULT = Config.create(Collections.emptyMap());
    }
}

