/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.Endpoint;

public class NeptuneInstanceMetadata
implements Endpoint {
    private static final Collection<String> AVAILABLE_STATES = Arrays.asList("available", "backing-up", "modifying", "upgrading");
    private String instanceId;
    private String role;
    private String address;
    private String status;
    private String availabilityZone;
    private String instanceType;
    private final Map<String, String> annotations = new HashMap<String, String>();
    private final Map<String, String> tags = new HashMap<String, String>();

    public static NeptuneInstanceMetadata fromByteArray(byte[] bytes) throws IOException {
        return (NeptuneInstanceMetadata)new ObjectMapper().readerFor(NeptuneInstanceMetadata.class).readValue(bytes);
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        this.address = endpoint;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public void setTags(Map<String, String> tags) {
        this.tags.clear();
        this.tags.putAll(tags);
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations.clear();
        this.annotations.putAll(annotations);
    }

    @Override
    public void setAnnotation(String key, String value) {
        this.annotations.put(key, value);
    }

    public NeptuneInstanceMetadata withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public NeptuneInstanceMetadata withRole(String role) {
        this.setRole(role);
        return this;
    }

    public NeptuneInstanceMetadata withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public NeptuneInstanceMetadata withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public NeptuneInstanceMetadata withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public NeptuneInstanceMetadata withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public NeptuneInstanceMetadata withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public NeptuneInstanceMetadata withAnnotations(Map<String, String> annotations) {
        this.setAnnotations(annotations);
        return this;
    }

    public NeptuneInstanceMetadata withAnnotation(String key, String value) {
        this.annotations.put(key, value);
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public boolean hasTag(String tag) {
        return this.tags.containsKey(tag);
    }

    public String getTag(String tag) {
        return this.tags.get(tag);
    }

    public String getTag(String tag, String defaultValue) {
        if (!this.tags.containsKey(tag)) {
            return defaultValue;
        }
        return this.tags.get(tag);
    }

    public boolean hasTag(String tag, String value) {
        return this.hasTag(tag) && this.getTag(tag).equals(value);
    }

    @Override
    @JsonIgnore
    public boolean isAvailable() {
        return this.address != null && AVAILABLE_STATES.contains(this.getStatus().toLowerCase());
    }

    @JsonIgnore
    public boolean isPrimary() {
        return this.getRole().equalsIgnoreCase("writer");
    }

    @JsonIgnore
    public boolean isReader() {
        return this.getRole().equalsIgnoreCase("reader");
    }

    public String toString() {
        return "NeptuneEndpointMetadata{instanceId='" + this.instanceId + "', role='" + this.role + "', address='" + this.address + "', status='" + this.status + "', availabilityZone='" + this.availabilityZone + "', instanceType='" + this.instanceType + "', annotations=" + this.annotations + ", tags=" + this.tags + "}";
    }

    public String toJsonString() throws JsonProcessingException {
        return new ObjectMapper().writerFor(this.getClass()).writeValueAsString((Object)this);
    }
}

