/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.EndpointRequestMetrics;

class RequestMetricsCollector {
    private static final int MAX_NUMBER_TRACE_IDS = 9000;
    public final Map<String, EndpointRequestMetrics> metrics;
    public final Map<UUID, String> traceIds = new LinkedHashMap<UUID, String>(16, 0.75f, true);
    private int dropped = 0;
    private int skipped = 0;

    public RequestMetricsCollector(Map<String, EndpointRequestMetrics> metrics) {
        this.metrics = metrics;
    }

    public void registerAddressForTraceId(UUID traceId, String address) {
        if (this.traceIds.size() > 9000) {
            UUID toRemove = this.traceIds.keySet().iterator().next();
            this.traceIds.remove(toRemove);
            ++this.dropped;
        }
        this.traceIds.put(traceId, address);
    }

    public void registerDurationForTraceId(UUID traceId, long durationMillis, Throwable e) {
        String address = this.traceIds.remove(traceId);
        if (address != null) {
            if (this.metrics.containsKey(address)) {
                this.metrics.get(address).update(durationMillis, e);
            } else {
                ++this.skipped;
            }
        } else {
            ++this.skipped;
        }
    }

    public int droppedRequests() {
        return this.dropped;
    }

    public int skippedResponses() {
        return this.skipped;
    }

    public long totalRequests() {
        long totalRequests = 0L;
        for (EndpointRequestMetrics rm : this.metrics.values()) {
            totalRequests += rm.getSuccessCount() + rm.getErrorCount();
        }
        return totalRequests;
    }

    public long failedRequests() {
        long failedRequests = 0L;
        for (EndpointRequestMetrics rm : this.metrics.values()) {
            failedRequests += rm.getErrorCount();
        }
        return failedRequests;
    }

    public Collection<EndpointRequestMetrics> metrics() {
        return this.metrics.values();
    }
}

