/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.driver.ApprovalResult;
import org.apache.tinkerpop.gremlin.driver.ClientClusterCollection;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointFilter;

public class EndpointCollection
implements Iterable<Endpoint> {
    private final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();

    public EndpointCollection() {
    }

    public EndpointCollection(Collection<? extends Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOrReplace(endpoint);
        }
    }

    public EndpointCollection(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOrReplace(endpoint);
        }
    }

    EndpointCollection getEndpointsWithNoCluster(ClientClusterCollection clientClusterCollection) {
        EndpointCollection results = new EndpointCollection();
        for (Endpoint endpoint : this.endpoints.values()) {
            if (clientClusterCollection.containsClusterForEndpoint(endpoint)) continue;
            results.addOrReplace(endpoint);
        }
        return results;
    }

    EndpointCollection getEnrichedEndpoints(EndpointFilter endpointFilter) {
        EndpointCollection results = new EndpointCollection();
        for (Endpoint endpoint : this.endpoints.values()) {
            results.addOrReplace(endpointFilter.enrichEndpoint(endpoint));
        }
        return results;
    }

    EndpointCollection getAcceptedEndpoints(EndpointFilter endpointFilter) {
        EndpointCollection results = new EndpointCollection();
        for (Endpoint endpoint : this.endpoints.values()) {
            ApprovalResult approvalResult = endpointFilter.approveEndpoint(endpoint);
            if (!approvalResult.isApproved()) continue;
            results.addOrReplace(endpoint);
        }
        return results;
    }

    EndpointCollection getRejectedEndpoints(EndpointFilter endpointFilter) {
        EndpointCollection results = new EndpointCollection();
        for (Endpoint endpoint : this.endpoints.values()) {
            ApprovalResult approvalResult = endpointFilter.approveEndpoint(endpoint);
            if (approvalResult.isApproved()) continue;
            results.addOrReplace(approvalResult.enrich(endpoint));
        }
        return results;
    }

    private void addOrReplace(Endpoint endpoint) {
        this.endpoints.put(this.computeKey(endpoint), endpoint);
    }

    public boolean containsEndpoint(Endpoint endpoint) {
        return this.endpoints.containsKey(endpoint.getAddress());
    }

    public Endpoint get(String address) {
        return this.endpoints.get(address);
    }

    public boolean isEmpty() {
        return this.endpoints.isEmpty();
    }

    @Override
    public Iterator<Endpoint> iterator() {
        return this.endpoints.values().iterator();
    }

    public Stream<Endpoint> stream() {
        return this.endpoints.values().stream();
    }

    public String toString() {
        return "EndpointCollection{endpoints=" + this.endpoints + "}";
    }

    private String computeKey(Endpoint endpoint) {
        return endpoint.getAddress() != null ? endpoint.getAddress() : String.valueOf(endpoint.hashCode());
    }

    public int size() {
        return this.endpoints.size();
    }
}

