/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.driver.EagerRefreshContext;
import org.apache.tinkerpop.gremlin.driver.OnEagerRefresh;
import org.apache.tinkerpop.gremlin.driver.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.utils.Clock;

class ConnectionAttemptManager
implements AutoCloseable {
    private final Refreshable client;
    private final AtomicBoolean refreshing;
    private final AtomicLong latestRefreshTime;
    private final int maxWaitForConnection;
    private final int eagerRefreshWaitTimeMillis;
    private final OnEagerRefresh onEagerRefresh;
    private final ExecutorService executorService;
    private final int eagerRefreshBackoffMillis;
    private final Clock clock;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionAttemptManager.class);

    ConnectionAttemptManager(Refreshable client, int maxWaitForConnection, int eagerRefreshWaitTimeMillis, OnEagerRefresh onEagerRefresh, int eagerRefreshBackoffMillis, Clock clock) {
        this(client, maxWaitForConnection, eagerRefreshWaitTimeMillis, onEagerRefresh, eagerRefreshBackoffMillis, clock, Executors.newSingleThreadExecutor(), 0L, false);
    }

    ConnectionAttemptManager(Refreshable client, int maxWaitForConnection, int eagerRefreshWaitTimeMillis, OnEagerRefresh onEagerRefresh, int eagerRefreshBackoffMillis, Clock clock, ExecutorService executorService, long latestRefreshTime, boolean isRefreshing) {
        this.client = client;
        this.maxWaitForConnection = maxWaitForConnection;
        this.eagerRefreshWaitTimeMillis = eagerRefreshWaitTimeMillis;
        this.onEagerRefresh = onEagerRefresh;
        this.eagerRefreshBackoffMillis = eagerRefreshBackoffMillis;
        this.clock = clock;
        this.executorService = executorService;
        this.latestRefreshTime = new AtomicLong(latestRefreshTime);
        this.refreshing = new AtomicBoolean(isRefreshing);
        logger.info("maxWaitForConnection: {}, eagerRefreshWaitTimeMillis: {}, eagerRefreshBackoffMillis: {}", new Object[]{this.maxWaitForConnection, this.eagerRefreshWaitTimeMillis, this.eagerRefreshBackoffMillis});
    }

    public boolean maxWaitTimeExceeded(long start) {
        return this.waitTime(start) > (long)this.maxWaitForConnection;
    }

    public boolean eagerRefreshWaitTimeExceeded(long start) {
        return this.eagerRefreshWaitTimeMillis > 0 && this.waitTime(start) > (long)this.eagerRefreshWaitTimeMillis;
    }

    public void triggerEagerRefresh(EagerRefreshContext context) {
        String message = String.format("Wait time to get connection has exceeded threshold [%s millis]", this.eagerRefreshWaitTimeMillis);
        if (this.onEagerRefresh == null) {
            return;
        }
        long lastRefreshTime = this.latestRefreshTime.get();
        if (lastRefreshTime > 0L && this.waitTime(lastRefreshTime) < (long)this.eagerRefreshBackoffMillis) {
            logger.warn("{} but last refresh occurred within backoff interval, so not getting new endpoints", (Object)message);
            return;
        }
        boolean isRefreshing = this.refreshing.get();
        if (!isRefreshing) {
            logger.warn("{} so getting new endpoints", (Object)message);
            this.executorService.submit(new RefreshEventTask(context, this.client, this.refreshing, this.latestRefreshTime, this.onEagerRefresh, this.clock));
        } else {
            logger.warn("{} but already refreshing, so not getting new endpoints", (Object)message);
        }
    }

    private long waitTime(long start) {
        return this.clock.currentTimeMillis() - start;
    }

    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public void close() throws Exception {
        this.shutdownNow();
    }

    static class RefreshEventTask
    implements Runnable {
        private final EagerRefreshContext context;
        private final Refreshable client;
        private final AtomicBoolean refreshing;
        private final AtomicLong latestRefreshTime;
        private final OnEagerRefresh onEagerRefresh;
        private final Clock clock;

        RefreshEventTask(EagerRefreshContext context, Refreshable client, AtomicBoolean refreshing, AtomicLong latestRefreshTime, OnEagerRefresh onEagerRefresh, Clock clock) {
            this.context = context;
            this.client = client;
            this.refreshing = refreshing;
            this.latestRefreshTime = latestRefreshTime;
            this.onEagerRefresh = onEagerRefresh;
            this.clock = clock;
        }

        @Override
        public void run() {
            boolean allowRefresh = this.refreshing.compareAndSet(false, true);
            if (allowRefresh) {
                this.client.refreshEndpoints(this.onEagerRefresh.getEndpoints(this.context));
                this.refreshing.set(false);
                this.latestRefreshTime.getAndUpdate(currentValue -> Math.max(this.clock.currentTimeMillis(), currentValue));
            } else {
                logger.warn("Already refreshing, so taking no action");
            }
        }
    }
}

