/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.ApprovalResult;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.DatabaseEndpoint;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointFilter;
import org.apache.tinkerpop.gremlin.driver.EndpointsUnavailableException;
import org.apache.tinkerpop.gremlin.driver.GremlinCluster;
import org.apache.tinkerpop.gremlin.driver.GremlinClusterBuilder;
import org.apache.tinkerpop.gremlin.driver.HandshakeInterceptor;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MetricsHandler;
import org.apache.tinkerpop.gremlin.driver.OnEagerRefresh;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.Serializers;
import software.amazon.neptune.cluster.HandshakeInterceptorConfigurator;
import software.amazon.neptune.cluster.SuspendedEndpoints;

public class NeptuneGremlinClusterBuilder {
    private final GremlinClusterBuilder innerBuilder = GremlinClusterBuilder.build();
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private String proxyAddress;
    private boolean removeHostHeader = false;
    private boolean enableSsl = true;
    private boolean enableIamAuth = false;
    private int port = 8182;
    private int proxyPort = 80;
    private String iamProfile = "default";
    private String serviceRegion = "";
    private HandshakeInterceptor interceptor = null;
    private AWSCredentialsProvider credentials = null;
    private EndpointFilter endpointFilter = new SuspendedEndpoints();

    public static NeptuneGremlinClusterBuilder build() {
        return new NeptuneGremlinClusterBuilder();
    }

    private NeptuneGremlinClusterBuilder() {
    }

    public NeptuneGremlinClusterBuilder addMetricsHandler(MetricsHandler handler) {
        this.innerBuilder.addMetricsHandler(handler);
        return this;
    }

    public NeptuneGremlinClusterBuilder enableMetrics(boolean enableMetrics) {
        this.innerBuilder.enableMetrics(enableMetrics);
        return this;
    }

    public NeptuneGremlinClusterBuilder acquireConnectionBackoffMillis(int acquireConnectionBackoffMillis) {
        this.innerBuilder.acquireConnectionBackoffMillis(acquireConnectionBackoffMillis);
        return this;
    }

    public NeptuneGremlinClusterBuilder eagerRefreshBackoffMillis(int eagerRefreshBackoffMillis) {
        this.innerBuilder.eagerRefreshBackoffMillis(eagerRefreshBackoffMillis);
        return this;
    }

    public NeptuneGremlinClusterBuilder eagerRefreshWaitTimeMillis(int eagerRefreshWaitTimeMillis) {
        this.innerBuilder.eagerRefreshWaitTimeMillis(eagerRefreshWaitTimeMillis);
        return this;
    }

    public NeptuneGremlinClusterBuilder onEagerRefresh(OnEagerRefresh eventHandler) {
        this.innerBuilder.onEagerRefresh(eventHandler);
        return this;
    }

    public NeptuneGremlinClusterBuilder endpointFilter(EndpointFilter endpointFilter) {
        this.endpointFilter = endpointFilter;
        return this;
    }

    public NeptuneGremlinClusterBuilder nioPoolSize(int nioPoolSize) {
        this.innerBuilder.nioPoolSize(nioPoolSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder workerPoolSize(int workerPoolSize) {
        this.innerBuilder.workerPoolSize(workerPoolSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder path(String path) {
        this.innerBuilder.path(path);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(String mimeType) {
        this.innerBuilder.serializer(mimeType);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(Serializers mimeType) {
        this.innerBuilder.serializer(mimeType);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(MessageSerializer serializer) {
        this.innerBuilder.serializer(serializer);
        return this;
    }

    public NeptuneGremlinClusterBuilder enableSsl(boolean enable) {
        this.enableSsl = enable;
        return this;
    }

    public NeptuneGremlinClusterBuilder sslContext(SslContext sslContext) {
        this.innerBuilder.sslContext(sslContext);
        return this;
    }

    public NeptuneGremlinClusterBuilder keepAliveInterval(long keepAliveInterval) {
        this.innerBuilder.keepAliveInterval(keepAliveInterval);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStore(String keyStore) {
        this.innerBuilder.keyStore(keyStore);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStorePassword(String keyStorePassword) {
        this.innerBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public NeptuneGremlinClusterBuilder trustStore(String trustStore) {
        this.innerBuilder.trustStore(trustStore);
        return this;
    }

    public NeptuneGremlinClusterBuilder trustStorePassword(String trustStorePassword) {
        this.innerBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStoreType(String keyStoreType) {
        this.innerBuilder.keyStoreType(keyStoreType);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslEnabledProtocols(List<String> sslEnabledProtocols) {
        this.innerBuilder.sslEnabledProtocols(sslEnabledProtocols);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslCipherSuites(List<String> sslCipherSuites) {
        this.innerBuilder.sslCipherSuites(sslCipherSuites);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslSkipCertValidation(boolean sslSkipCertValidation) {
        this.innerBuilder.sslSkipCertValidation(sslSkipCertValidation);
        return this;
    }

    public NeptuneGremlinClusterBuilder minInProcessPerConnection(int minInProcessPerConnection) {
        this.innerBuilder.minInProcessPerConnection(minInProcessPerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxInProcessPerConnection(int maxInProcessPerConnection) {
        this.innerBuilder.maxInProcessPerConnection(maxInProcessPerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
        this.innerBuilder.maxSimultaneousUsagePerConnection(maxSimultaneousUsagePerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
        this.innerBuilder.minSimultaneousUsagePerConnection(minSimultaneousUsagePerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxConnectionPoolSize(int maxSize) {
        this.innerBuilder.maxConnectionPoolSize(maxSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder minConnectionPoolSize(int minSize) {
        this.innerBuilder.minConnectionPoolSize(minSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder resultIterationBatchSize(int size) {
        this.innerBuilder.resultIterationBatchSize(size);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxWaitForConnection(int maxWait) {
        this.innerBuilder.maxWaitForConnection(maxWait);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxWaitForClose(int maxWait) {
        this.innerBuilder.maxWaitForClose(maxWait);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxContentLength(int maxContentLength) {
        this.innerBuilder.maxContentLength(maxContentLength);
        return this;
    }

    public NeptuneGremlinClusterBuilder channelizer(String channelizerClass) {
        this.innerBuilder.channelizer(channelizerClass);
        return this;
    }

    public NeptuneGremlinClusterBuilder channelizer(Class channelizerClass) {
        return this.channelizer(channelizerClass.getCanonicalName());
    }

    public NeptuneGremlinClusterBuilder validationRequest(String script) {
        this.innerBuilder.validationRequest(script);
        return this;
    }

    public NeptuneGremlinClusterBuilder reconnectInterval(int interval) {
        this.innerBuilder.reconnectInterval(interval);
        return this;
    }

    public NeptuneGremlinClusterBuilder loadBalancingStrategy(Supplier<LoadBalancingStrategy> loadBalancingStrategy) {
        this.innerBuilder.loadBalancingStrategy(loadBalancingStrategy);
        return this;
    }

    public NeptuneGremlinClusterBuilder authProperties(AuthProperties authProps) {
        this.innerBuilder.authProperties(authProps);
        return this;
    }

    public NeptuneGremlinClusterBuilder credentials(String username, String password) {
        this.innerBuilder.credentials(username, password);
        return this;
    }

    public NeptuneGremlinClusterBuilder protocol(String protocol) {
        this.innerBuilder.protocol(protocol);
        return this;
    }

    public NeptuneGremlinClusterBuilder jaasEntry(String jaasEntry) {
        this.innerBuilder.jaasEntry(jaasEntry);
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoint(String address) {
        this.endpoints.add(new DatabaseEndpoint().withAddress(address));
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoints(String ... addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoints(Collection<String> addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoints(EndpointCollection endpointCollection) {
        for (Endpoint endpoint : endpointCollection) {
            this.addContactPoint(endpoint);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPointsMetadata(Endpoint ... endpointCollection) {
        for (Endpoint endpoint : endpointCollection) {
            this.addContactPoint(endpoint);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPointsMetadata(Collection<Endpoint> endpointCollection) {
        for (Endpoint endpoint : endpointCollection) {
            this.addContactPoint(endpoint);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder port(int port) {
        this.port = port;
        return this;
    }

    public NeptuneGremlinClusterBuilder proxyPort(int port) {
        this.proxyPort = port;
        return this;
    }

    public NeptuneGremlinClusterBuilder proxyAddress(String address) {
        this.proxyAddress = address;
        return this;
    }

    public NeptuneGremlinClusterBuilder proxyRemoveHostHeader(boolean removeHostHeader) {
        this.removeHostHeader = removeHostHeader;
        return this;
    }

    public NeptuneGremlinClusterBuilder enableIamAuth(boolean enable) {
        this.enableIamAuth = enable;
        return this;
    }

    public NeptuneGremlinClusterBuilder serviceRegion(String serviceRegion) {
        this.serviceRegion = serviceRegion;
        return this;
    }

    public NeptuneGremlinClusterBuilder iamProfile(String iamProfile) {
        this.iamProfile = iamProfile;
        return this;
    }

    public NeptuneGremlinClusterBuilder handshakeInterceptor(HandshakeInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public NeptuneGremlinClusterBuilder credentials(AWSCredentialsProvider credentials) {
        this.credentials = credentials;
        return this;
    }

    private boolean isDirectConnection() {
        return this.proxyAddress == null;
    }

    public GremlinCluster create() {
        this.innerBuilder.enableSsl(this.enableSsl);
        ArrayList<Endpoint> filteredEndpoints = new ArrayList<Endpoint>();
        HashSet<String> rejectedReasons = new HashSet<String>();
        if (this.endpointFilter != null) {
            this.innerBuilder.endpointFilter(this.endpointFilter);
            for (Endpoint endpoint : this.endpoints) {
                ApprovalResult approvalResult = this.endpointFilter.approveEndpoint(endpoint);
                if (approvalResult.isApproved()) {
                    filteredEndpoints.add(endpoint);
                    continue;
                }
                rejectedReasons.add(approvalResult.reason());
            }
        } else {
            filteredEndpoints.addAll(this.endpoints);
        }
        if (filteredEndpoints.isEmpty()) {
            if (!rejectedReasons.isEmpty()) {
                throw new EndpointsUnavailableException(rejectedReasons);
            }
            if (this.isDirectConnection()) {
                throw new IllegalStateException("The list of endpoint addresses is empty. You must supply one or more endpoints.");
            }
            if (this.enableIamAuth) {
                throw new IllegalStateException("The list of endpoint addresses is empty. You must supply one or more endpoints to sign the Host header.");
            }
        }
        for (Endpoint endpoint : filteredEndpoints) {
            this.innerBuilder.addContactPoint(endpoint);
        }
        HandshakeInterceptorConfigurator configurator = new HandshakeInterceptorConfigurator(this.isDirectConnection(), this.interceptor, this.enableIamAuth, this.port, this.proxyPort, this.proxyAddress, this.serviceRegion, this.iamProfile, this.credentials, this.removeHostHeader);
        this.innerBuilder.topologyAwareBuilderConfigurator(configurator);
        return this.innerBuilder.create();
    }
}

