/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataSupplier;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;

class CommonClusterEndpointsFetchStrategy
implements ClusterEndpointsFetchStrategy {
    private final ClusterMetadataSupplier clusterMetadataSupplier;

    CommonClusterEndpointsFetchStrategy(ClusterMetadataSupplier clusterMetadataSupplier) {
        this.clusterMetadataSupplier = clusterMetadataSupplier;
    }

    @Override
    public ClusterMetadataSupplier clusterMetadataSupplier() {
        return this.clusterMetadataSupplier;
    }

    @Override
    public Map<? extends EndpointsSelector, EndpointCollection> getEndpoints(Collection<? extends EndpointsSelector> selectors, boolean refresh) {
        if (refresh) {
            return this.refreshEndpoints(selectors);
        }
        NeptuneClusterMetadata clusterMetadata = this.clusterMetadataSupplier().getClusterMetadata();
        if (clusterMetadata == null) {
            return this.refreshEndpoints(selectors);
        }
        HashMap<EndpointsSelector, EndpointCollection> results = new HashMap<EndpointsSelector, EndpointCollection>();
        for (EndpointsSelector endpointsSelector : selectors) {
            results.put(endpointsSelector, clusterMetadata.select(endpointsSelector));
        }
        return results;
    }

    private Map<? extends EndpointsSelector, EndpointCollection> refreshEndpoints(Collection<? extends EndpointsSelector> selectors) {
        NeptuneClusterMetadata clusterMetadata = this.clusterMetadataSupplier.refreshClusterMetadata();
        HashMap<EndpointsSelector, EndpointCollection> results = new HashMap<EndpointsSelector, EndpointCollection>();
        for (EndpointsSelector endpointsSelector : selectors) {
            results.put(endpointsSelector, clusterMetadata.select(endpointsSelector));
        }
        return results;
    }
}

