/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import com.amazonaws.util.StringUtils;
import org.apache.tinkerpop.gremlin.driver.MetricsHandlerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.utils.EnvironmentVariableUtils;

class MetricsConfig {
    private static final String PROPERTY_NAME = "org.apache.tinkerpop.gremlin.driver.MetricsConfig.enableMetrics";
    private static final Logger logger = LoggerFactory.getLogger(MetricsConfig.class);
    private final boolean enableMetrics;
    private final MetricsHandlerCollection metricsHandlers;

    MetricsConfig(boolean enableMetrics, MetricsHandlerCollection metricsHandlers) {
        this.enableMetrics = this.calculateEnableMetricsValue(enableMetrics);
        this.metricsHandlers = metricsHandlers;
    }

    public boolean enableMetrics() {
        return this.enableMetrics;
    }

    public MetricsHandlerCollection metricsHandlers() {
        return this.metricsHandlers;
    }

    private boolean calculateEnableMetricsValue(boolean enableMetricsBuilder) {
        String sysProp;
        Boolean enableMetricsEnv = null;
        Boolean enableMetricsSys = null;
        String envVar = EnvironmentVariableUtils.getOptionalEnv(PROPERTY_NAME, null);
        if (!StringUtils.isNullOrEmpty((String)envVar)) {
            enableMetricsEnv = Boolean.parseBoolean(envVar);
        }
        if (!StringUtils.isNullOrEmpty((String)(sysProp = System.getProperty(PROPERTY_NAME, null)))) {
            enableMetricsSys = Boolean.parseBoolean(sysProp);
        }
        boolean result = false;
        if (enableMetricsEnv != null && !enableMetricsEnv.booleanValue() || enableMetricsSys != null && !enableMetricsSys.booleanValue()) {
            result = false;
        } else if (enableMetricsBuilder || enableMetricsEnv != null || enableMetricsSys != null) {
            result = true;
        }
        logger.debug("Enable metrics: {} [builder: {}, env: {}, sys: {}]", new Object[]{result, enableMetricsBuilder, enableMetricsEnv, enableMetricsSys});
        return result;
    }
}

