/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.ConnectionMetrics;
import org.apache.tinkerpop.gremlin.driver.EndpointConnectionMetrics;
import org.apache.tinkerpop.gremlin.driver.EndpointRequestMetrics;
import org.apache.tinkerpop.gremlin.driver.MetricsHandler;
import org.apache.tinkerpop.gremlin.driver.RequestMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsLogger
implements MetricsHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetricsLogger.class);

    MetricsLogger() {
    }

    @Override
    public void onMetricsPublished(ConnectionMetrics connectionMetrics, RequestMetrics requestMetrics) {
        logger.info("Connection metrics: [duration: {}ms, totalConnectionAttempts:{}, endpoints: [{}]]", new Object[]{connectionMetrics.getDurationMillis(), connectionMetrics.getTotalConnectionAttempts(), connectionMetrics.getMetrics().stream().map(EndpointConnectionMetrics::toString).collect(Collectors.joining(", "))});
        logger.info("Request metrics: [duration: {}ms, totalRequests:{}, failed: {}, endpoints: [{}] (dropped: {}, skipped: {})]", new Object[]{requestMetrics.getDurationMillis(), requestMetrics.getTotalRequests(), requestMetrics.getFailedRequestsCount(), requestMetrics.getMetrics().stream().map(EndpointRequestMetrics::toString).collect(Collectors.joining(", ")), requestMetrics.getDroppedRequestsCount(), requestMetrics.getSkippedResponsesCount()});
    }
}

