/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.AcquireConnectionConfig;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.ClientClusterCollection;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ClusterFactory;
import org.apache.tinkerpop.gremlin.driver.DatabaseEndpoint;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointClient;
import org.apache.tinkerpop.gremlin.driver.EndpointClientCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointStrategies;
import org.apache.tinkerpop.gremlin.driver.GremlinClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.utils.GitProperties;
import software.amazon.utils.SoftwareVersion;

public class GremlinCluster
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinCluster.class);
    private final Collection<Endpoint> defaultEndpoints;
    private final ClusterFactory clusterFactory;
    private final Collection<ClientClusterCollection> clientClusterCollections = new CopyOnWriteArrayList<ClientClusterCollection>();
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private final EndpointStrategies endpointStrategies;
    private final AcquireConnectionConfig acquireConnectionConfig;

    public GremlinCluster(Collection<Endpoint> defaultEndpoints, ClusterFactory clusterFactory, EndpointStrategies endpointStrategies, AcquireConnectionConfig acquireConnectionConfig) {
        logger.info("Version: {} {}", (Object)SoftwareVersion.FromResource, (Object)GitProperties.FromResource);
        logger.info("Created GremlinCluster, defaultEndpoints: {}", defaultEndpoints.stream().map(Endpoint::getAddress).collect(Collectors.toList()));
        this.defaultEndpoints = defaultEndpoints;
        this.clusterFactory = clusterFactory;
        this.endpointStrategies = endpointStrategies;
        this.acquireConnectionConfig = acquireConnectionConfig;
    }

    public GremlinClient connect(List<String> addresses, Client.Settings settings) {
        return this.connectToEndpoints(addresses.stream().map(a -> new DatabaseEndpoint().withAddress((String)a)).collect(Collectors.toList()), settings);
    }

    public GremlinClient connectToEndpoints(Collection<Endpoint> endpoints, Client.Settings settings) {
        logger.info("Connecting with: {}", endpoints.stream().map(Endpoint::getAddress).collect(Collectors.toList()));
        if (endpoints.isEmpty()) {
            throw new IllegalStateException("You must supply at least one endpoint");
        }
        Cluster parentCluster = this.clusterFactory.createCluster(null);
        ClientClusterCollection clientClusterCollection = new ClientClusterCollection(this.clusterFactory, parentCluster);
        ArrayList<EndpointClient> endpointClientList = new ArrayList<EndpointClient>();
        for (Endpoint endpoint : endpoints) {
            Cluster cluster = clientClusterCollection.createClusterForEndpoint(endpoint);
            Client client = cluster.connect().init();
            endpointClientList.add(new EndpointClient(endpoint, client));
        }
        EndpointClientCollection endpointClientCollection = new EndpointClientCollection(endpointClientList);
        this.clientClusterCollections.add(clientClusterCollection);
        return new GremlinClient(clientClusterCollection.getParentCluster(), settings, endpointClientCollection, clientClusterCollection, this.clusterFactory, this.endpointStrategies, this.acquireConnectionConfig);
    }

    public GremlinClient connect(List<String> addresses) {
        return this.connect(addresses, Client.Settings.build().create());
    }

    public GremlinClient connectToEndpoints(List<Endpoint> endpoints) {
        return this.connectToEndpoints(endpoints, Client.Settings.build().create());
    }

    public GremlinClient connect() {
        return this.connectToEndpoints(this.defaultEndpoints, Client.Settings.build().create());
    }

    public GremlinClient connect(Client.Settings settings) {
        return this.connectToEndpoints(this.defaultEndpoints, settings);
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ClientClusterCollection clientClusterCollection : this.clientClusterCollections) {
            futures.add(clientClusterCollection.closeAsync());
        }
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().join();
    }
}

