/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.TooManyRequestsException;
import com.evanlennick.retry4j.CallExecutor;
import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import com.evanlennick.retry4j.exception.UnexpectedException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.EndpointsType;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.utils.RegionUtils;

public class GetEndpointsFromLambdaProxy
implements ClusterEndpointsFetchStrategy {
    private final EndpointsSelector endpointsSelector;
    private final String lambdaName;
    private final AWSLambda lambdaClient;
    private final RetryConfig retryConfig;

    public GetEndpointsFromLambdaProxy(EndpointsSelector endpointsSelector, String lambdaName) {
        this(endpointsSelector, lambdaName, RegionUtils.getCurrentRegionName());
    }

    public GetEndpointsFromLambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region) {
        this(endpointsSelector, lambdaName, region, "default");
    }

    public GetEndpointsFromLambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region, String iamProfile) {
        this(endpointsSelector, lambdaName, region, iamProfile, null);
    }

    public GetEndpointsFromLambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region, AWSCredentialsProvider credentials) {
        this(endpointsSelector, lambdaName, region, "default", credentials);
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName) {
        this(endpointsType, lambdaName, RegionUtils.getCurrentRegionName());
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region) {
        this(endpointsType, lambdaName, region, "default");
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region, String iamProfile) {
        this(endpointsType, lambdaName, region, iamProfile, null);
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region, AWSCredentialsProvider credentials) {
        this(endpointsType, lambdaName, region, "default", credentials);
    }

    private GetEndpointsFromLambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region, String iamProfile, AWSCredentialsProvider credentials) {
        this.endpointsSelector = endpointsSelector;
        this.lambdaName = lambdaName;
        this.lambdaClient = this.createLambdaClient(region, iamProfile, credentials);
        this.retryConfig = new RetryConfigBuilder().retryOnSpecificExceptions(new Class[]{TooManyRequestsException.class}).withMaxNumberOfTries(10).withDelayBetweenTries(10L, ChronoUnit.MILLIS).withExponentialBackoff().build();
    }

    private AWSLambda createLambdaClient(String region, String iamProfile, AWSCredentialsProvider credentials) {
        AWSLambdaClientBuilder builder = AWSLambdaClientBuilder.standard();
        builder = credentials != null ? (AWSLambdaClientBuilder)builder.withCredentials(credentials) : (!iamProfile.equals("default") ? (AWSLambdaClientBuilder)builder.withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(iamProfile)) : (AWSLambdaClientBuilder)builder.withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance()));
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            builder = (AWSLambdaClientBuilder)builder.withRegion(region);
        }
        return (AWSLambda)builder.build();
    }

    @Override
    public Map<EndpointsSelector, Collection<String>> getAddresses() {
        if (EndpointsType.class.isAssignableFrom(this.endpointsSelector.getClass())) {
            return this.getAddressesForEndpointsType();
        }
        return this.getAddressesForCustomEndpointsSelector();
    }

    private Map<EndpointsSelector, Collection<String>> getAddressesForCustomEndpointsSelector() {
        Status status;
        Callable<NeptuneClusterMetadata> query = () -> {
            InvokeRequest invokeRequest = new InvokeRequest().withFunctionName(this.lambdaName).withPayload("\"\"");
            InvokeResult result = this.lambdaClient.invoke(invokeRequest);
            return NeptuneClusterMetadata.fromByeArray(result.getPayload().array());
        };
        CallExecutor executor = new CallExecutorBuilder().config(this.retryConfig).build();
        try {
            status = executor.execute(query);
        }
        catch (UnexpectedException e) {
            if (e.getCause() instanceof MismatchedInputException) {
                throw new IllegalStateException(String.format("The AWS Lambda proxy (%s) isn't returning a NeptuneClusterMetadata JSON document. Check that the function supports returning a NeptuneClusterMetadata JSON document.", this.lambdaName), e.getCause());
            }
            throw new IllegalStateException(String.format("There was an unexpected error while attempting to get a NeptuneClusterMetadata JSON document from the AWS Lambda proxy (%s). Check that the function supports returning a NeptuneClusterMetadata JSON document.", this.lambdaName), e.getCause());
        }
        NeptuneClusterMetadata neptuneClusterMetadata = (NeptuneClusterMetadata)status.getResult();
        HashMap<EndpointsSelector, Collection<String>> results = new HashMap<EndpointsSelector, Collection<String>>();
        results.put(this.endpointsSelector, this.endpointsSelector.getEndpoints(neptuneClusterMetadata.getClusterEndpoint(), neptuneClusterMetadata.getReaderEndpoint(), neptuneClusterMetadata.getInstances()));
        return results;
    }

    private Map<EndpointsSelector, Collection<String>> getAddressesForEndpointsType() {
        Status status;
        Callable<Map> query = () -> {
            EndpointsType endpointsType = (EndpointsType)this.endpointsSelector;
            InvokeRequest invokeRequest = new InvokeRequest().withFunctionName(this.lambdaName).withPayload(String.format("\"%s\"", endpointsType.name()));
            InvokeResult result = this.lambdaClient.invoke(invokeRequest);
            String payload = new String(result.getPayload().array());
            HashMap<EndpointsType, List<String>> results = new HashMap<EndpointsType, List<String>>();
            results.put(endpointsType, Arrays.asList(payload.split(",")));
            return results;
        };
        CallExecutor executor = new CallExecutorBuilder().config(this.retryConfig).build();
        try {
            status = executor.execute(query);
        }
        catch (UnexpectedException e) {
            throw new IllegalStateException(String.format("There was an unexpected error while attempting to get a list of endpoints from the AWS Lambda proxy (%s). Check that the function supports returning a list of endpoints.", this.lambdaName), e.getCause());
        }
        return (Map)status.getResult();
    }
}

