/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.GremlinCluster;
import org.apache.tinkerpop.gremlin.driver.GremlinClusterBuilder;
import org.apache.tinkerpop.gremlin.driver.HandshakeInterceptor;
import org.apache.tinkerpop.gremlin.driver.IamAuthConfig;
import org.apache.tinkerpop.gremlin.driver.LBAwareHandshakeInterceptor;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;

public class NeptuneGremlinClusterBuilder {
    private final GremlinClusterBuilder innerBuilder = GremlinClusterBuilder.build();
    private List<String> addresses = new ArrayList<String>();
    private String networkLoadBalancerEndpoint;
    private String applicationLoadBalancerEndpoint;
    private boolean enableIamAuth = false;
    private int port = 8182;
    private int loadBalancerPort = 80;
    private String iamProfile = "default";
    private String serviceRegion = "";
    private HandshakeInterceptor interceptor = null;
    private AWSCredentialsProvider credentials = null;

    public static NeptuneGremlinClusterBuilder build() {
        return new NeptuneGremlinClusterBuilder();
    }

    private NeptuneGremlinClusterBuilder() {
    }

    public NeptuneGremlinClusterBuilder refreshOnErrorThreshold(int refreshOnErrorThreshold) {
        this.innerBuilder.refreshOnErrorThreshold(refreshOnErrorThreshold);
        return this;
    }

    public NeptuneGremlinClusterBuilder refreshOnErrorEventHandler(Supplier<Collection<String>> refreshOnErrorEventHandler) {
        this.innerBuilder.refreshOnErrorEventHandler(refreshOnErrorEventHandler);
        return this;
    }

    public NeptuneGremlinClusterBuilder nioPoolSize(int nioPoolSize) {
        this.innerBuilder.nioPoolSize(nioPoolSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder workerPoolSize(int workerPoolSize) {
        this.innerBuilder.workerPoolSize(workerPoolSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder path(String path) {
        this.innerBuilder.path(path);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(String mimeType) {
        this.innerBuilder.serializer(mimeType);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(Serializers mimeType) {
        this.innerBuilder.serializer(mimeType);
        return this;
    }

    public NeptuneGremlinClusterBuilder serializer(MessageSerializer serializer) {
        this.innerBuilder.serializer(serializer);
        return this;
    }

    public NeptuneGremlinClusterBuilder enableSsl(boolean enable) {
        this.innerBuilder.enableSsl(enable);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslContext(SslContext sslContext) {
        this.innerBuilder.sslContext(sslContext);
        return this;
    }

    public NeptuneGremlinClusterBuilder keepAliveInterval(long keepAliveInterval) {
        this.innerBuilder.keepAliveInterval(keepAliveInterval);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStore(String keyStore) {
        this.innerBuilder.keyStore(keyStore);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStorePassword(String keyStorePassword) {
        this.innerBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public NeptuneGremlinClusterBuilder trustStore(String trustStore) {
        this.innerBuilder.trustStore(trustStore);
        return this;
    }

    public NeptuneGremlinClusterBuilder trustStorePassword(String trustStorePassword) {
        this.innerBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public NeptuneGremlinClusterBuilder keyStoreType(String keyStoreType) {
        this.innerBuilder.keyStoreType(keyStoreType);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslEnabledProtocols(List<String> sslEnabledProtocols) {
        this.innerBuilder.sslEnabledProtocols(sslEnabledProtocols);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslCipherSuites(List<String> sslCipherSuites) {
        this.innerBuilder.sslCipherSuites(sslCipherSuites);
        return this;
    }

    public NeptuneGremlinClusterBuilder sslSkipCertValidation(boolean sslSkipCertValidation) {
        this.innerBuilder.sslSkipCertValidation(sslSkipCertValidation);
        return this;
    }

    public NeptuneGremlinClusterBuilder minInProcessPerConnection(int minInProcessPerConnection) {
        this.innerBuilder.minInProcessPerConnection(minInProcessPerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxInProcessPerConnection(int maxInProcessPerConnection) {
        this.innerBuilder.maxInProcessPerConnection(maxInProcessPerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
        this.innerBuilder.maxSimultaneousUsagePerConnection(maxSimultaneousUsagePerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
        this.innerBuilder.minSimultaneousUsagePerConnection(minSimultaneousUsagePerConnection);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxConnectionPoolSize(int maxSize) {
        this.innerBuilder.maxConnectionPoolSize(maxSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder minConnectionPoolSize(int minSize) {
        this.innerBuilder.minConnectionPoolSize(minSize);
        return this;
    }

    public NeptuneGremlinClusterBuilder resultIterationBatchSize(int size) {
        this.innerBuilder.resultIterationBatchSize(size);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxWaitForConnection(int maxWait) {
        this.innerBuilder.maxWaitForConnection(maxWait);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxWaitForClose(int maxWait) {
        this.innerBuilder.maxWaitForClose(maxWait);
        return this;
    }

    public NeptuneGremlinClusterBuilder maxContentLength(int maxContentLength) {
        this.innerBuilder.maxContentLength(maxContentLength);
        return this;
    }

    public NeptuneGremlinClusterBuilder channelizer(String channelizerClass) {
        this.innerBuilder.channelizer(channelizerClass);
        return this;
    }

    public NeptuneGremlinClusterBuilder channelizer(Class channelizerClass) {
        return this.channelizer(channelizerClass.getCanonicalName());
    }

    public NeptuneGremlinClusterBuilder validationRequest(String script) {
        this.innerBuilder.validationRequest(script);
        return this;
    }

    public NeptuneGremlinClusterBuilder reconnectInterval(int interval) {
        this.innerBuilder.reconnectInterval(interval);
        return this;
    }

    public NeptuneGremlinClusterBuilder loadBalancingStrategy(Supplier<LoadBalancingStrategy> loadBalancingStrategy) {
        this.innerBuilder.loadBalancingStrategy(loadBalancingStrategy);
        return this;
    }

    public NeptuneGremlinClusterBuilder authProperties(AuthProperties authProps) {
        this.innerBuilder.authProperties(authProps);
        return this;
    }

    public NeptuneGremlinClusterBuilder credentials(String username, String password) {
        this.innerBuilder.credentials(username, password);
        return this;
    }

    public NeptuneGremlinClusterBuilder protocol(String protocol) {
        this.innerBuilder.protocol(protocol);
        return this;
    }

    public NeptuneGremlinClusterBuilder jaasEntry(String jaasEntry) {
        this.innerBuilder.jaasEntry(jaasEntry);
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoint(String address) {
        this.addresses.add(address);
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoints(String ... addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder addContactPoints(Collection<String> addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public NeptuneGremlinClusterBuilder port(int port) {
        this.port = port;
        return this;
    }

    public NeptuneGremlinClusterBuilder loadBalancerPort(int port) {
        this.loadBalancerPort = port;
        return this;
    }

    public NeptuneGremlinClusterBuilder networkLoadBalancerEndpoint(String endpoint) {
        this.networkLoadBalancerEndpoint = endpoint;
        return this;
    }

    public NeptuneGremlinClusterBuilder applicationLoadBalancerEndpoint(String endpoint) {
        this.applicationLoadBalancerEndpoint = endpoint;
        return this;
    }

    public NeptuneGremlinClusterBuilder enableIamAuth(boolean enable) {
        this.enableIamAuth = enable;
        return this;
    }

    public NeptuneGremlinClusterBuilder serviceRegion(String serviceRegion) {
        this.serviceRegion = serviceRegion;
        return this;
    }

    public NeptuneGremlinClusterBuilder iamProfile(String iamProfile) {
        this.iamProfile = iamProfile;
        return this;
    }

    public NeptuneGremlinClusterBuilder handshakeInterceptor(HandshakeInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public NeptuneGremlinClusterBuilder credentials(AWSCredentialsProvider credentials) {
        this.credentials = credentials;
        return this;
    }

    private boolean isDirectConnection() {
        return this.networkLoadBalancerEndpoint == null && this.applicationLoadBalancerEndpoint == null;
    }

    public GremlinCluster create() {
        if (this.addresses.isEmpty()) {
            if (this.isDirectConnection()) {
                throw new IllegalArgumentException("You must supply one or more Neptune endpoints");
            }
            if (this.enableIamAuth) {
                throw new IllegalArgumentException("You must supply one or more Neptune endpoints to sign the Host header");
            }
        }
        if (this.isDirectConnection()) {
            this.innerBuilder.port(this.port);
            for (String address : this.addresses) {
                this.innerBuilder.addContactPoint(address);
            }
        } else {
            this.innerBuilder.port(this.loadBalancerPort);
            if (this.networkLoadBalancerEndpoint != null) {
                this.innerBuilder.addContactPoint(this.networkLoadBalancerEndpoint);
            } else if (this.applicationLoadBalancerEndpoint != null) {
                this.innerBuilder.addContactPoint(this.applicationLoadBalancerEndpoint);
            }
        }
        if (this.interceptor != null) {
            this.innerBuilder.handshakeInterceptor(this.interceptor);
        } else if (this.enableIamAuth) {
            IamAuthConfig.IamAuthConfigBuilder iamAuthConfigBuilder = IamAuthConfig.builder().addNeptuneEndpoints(this.addresses).setNeptunePort(this.port).setServiceRegion(this.serviceRegion).setIamProfile(this.iamProfile).setCredentials(this.credentials);
            if (!this.isDirectConnection()) {
                iamAuthConfigBuilder.connectViaLoadBalancer();
            }
            if (this.applicationLoadBalancerEndpoint != null) {
                iamAuthConfigBuilder.removeHostHeaderAfterSigning();
            }
            IamAuthConfig iamAuthConfig = iamAuthConfigBuilder.build();
            this.innerBuilder.handshakeInterceptor(new LBAwareHandshakeInterceptor(iamAuthConfig));
        }
        return this.innerBuilder.create();
    }
}

