/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import lombok.NonNull;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.msk.auth.iam.internals.AWS4SignedPayloadGenerator;
import software.amazon.msk.auth.iam.internals.AWSCredentialsCallback;
import software.amazon.msk.auth.iam.internals.AuthenticationRequestParams;
import software.amazon.msk.auth.iam.internals.AuthenticationResponse;
import software.amazon.msk.auth.iam.internals.SignedPayloadGenerator;
import software.amazon.msk.auth.iam.internals.UserAgentUtils;

public class IAMSaslClient
implements SaslClient {
    private static final Logger log = LoggerFactory.getLogger(IAMSaslClient.class);
    private final String mechanism;
    private final CallbackHandler cbh;
    private final String serverName;
    private final SignedPayloadGenerator payloadGenerator;
    private State state;
    private String responseRequestId;

    public IAMSaslClient(@NonNull String mechanism, @NonNull CallbackHandler cbh, @NonNull String serverName, @NonNull SignedPayloadGenerator payloadGenerator) {
        if (mechanism == null) {
            throw new NullPointerException("mechanism is marked non-null but is null");
        }
        if (cbh == null) {
            throw new NullPointerException("cbh is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        if (payloadGenerator == null) {
            throw new NullPointerException("payloadGenerator is marked non-null but is null");
        }
        this.mechanism = mechanism;
        this.cbh = cbh;
        this.serverName = serverName;
        this.payloadGenerator = payloadGenerator;
        this.setState(State.SEND_CLIENT_FIRST_MESSAGE);
    }

    @Override
    public String getMechanismName() {
        return this.mechanism;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (log.isDebugEnabled()) {
            log.debug("State {} at start of evaluating challenge", (Object)this.state);
        }
        try {
            switch (this.state) {
                case SEND_CLIENT_FIRST_MESSAGE: {
                    if (!IAMSaslClient.isChallengeEmpty(challenge)) {
                        throw new SaslException("Expects an empty challenge in state " + (Object)((Object)this.state));
                    }
                    byte[] byArray = this.generateClientMessage();
                    return byArray;
                }
                case RECEIVE_SERVER_RESPONSE: {
                    if (IAMSaslClient.isChallengeEmpty(challenge)) {
                        throw new SaslException("Expects a non-empty authentication response in state " + (Object)((Object)this.state));
                    }
                    this.handleServerResponse(challenge);
                    this.setState(State.COMPLETE);
                    byte[] byArray = null;
                    return byArray;
                }
            }
            try {
                throw new IllegalSaslStateException("Challenge received in unexpected state " + (Object)((Object)this.state));
            }
            catch (SaslException se) {
                this.setState(State.FAILED);
                throw se;
            }
            catch (IOException | IllegalArgumentException | UnsupportedCallbackException e) {
                this.setState(State.FAILED);
                throw new SaslException("Exception while evaluating challenge", e);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("State {} at end of evaluating challenge", (Object)this.state);
            }
        }
    }

    private void handleServerResponse(byte[] challenge) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        AuthenticationResponse response = (AuthenticationResponse)mapper.readValue(challenge, AuthenticationResponse.class);
        if (response == null) {
            throw new SaslException("Invalid response from server ");
        }
        this.responseRequestId = response.getRequestId();
        if (log.isDebugEnabled()) {
            log.debug("Response from server: " + response.toString());
        }
    }

    private byte[] generateClientMessage() throws IOException, UnsupportedCallbackException {
        AWSCredentialsCallback callback = new AWSCredentialsCallback();
        this.cbh.handle(new Callback[]{callback});
        if (callback.isSuccessful()) {
            byte[] response = this.payloadGenerator.signedPayload(AuthenticationRequestParams.create(this.serverName, callback.getAwsCredentials(), UserAgentUtils.getUserAgentValue()));
            this.setState(State.RECEIVE_SERVER_RESPONSE);
            return response;
        }
        throw new SaslException("Failed to find AWS IAM Credentials", callback.getLoadingException());
    }

    @Override
    public boolean isComplete() {
        return State.COMPLETE.equals((Object)this.state);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    public String getResponseRequestId() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.responseRequestId;
    }

    private void setState(State state) {
        if (log.isDebugEnabled()) {
            log.debug("Setting SASL/{} client state to {}", (Object)this.mechanism, (Object)state);
        }
        this.state = state;
    }

    private static boolean isChallengeEmpty(byte[] challenge) {
        return challenge == null || challenge.length <= 0;
    }

    public static class IAMSaslClientFactory
    implements SaslClientFactory {
        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            for (String mechanism : mechanisms) {
                if (!"AWS_MSK_IAM".equals(mechanism)) continue;
                return new IAMSaslClient(mechanism, cbh, serverName, new AWS4SignedPayloadGenerator());
            }
            throw new SaslException("Requested mechanisms " + Arrays.asList(mechanisms) + " not supported. The supportedmechanism is " + "AWS_MSK_IAM");
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"AWS_MSK_IAM"};
        }
    }

    static enum State {
        SEND_CLIENT_FIRST_MESSAGE,
        RECEIVE_SERVER_RESPONSE,
        COMPLETE,
        FAILED;

    }
}

