/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.tracing.internal;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.tracing.PowertoolsTracing;

@Aspect
public final class LambdaTracingAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaTracingAspect ajc$perSingletonInstance;

    @Pointcut(value="@annotation(powerToolsTracing)")
    public /* synthetic */ void callAt(PowertoolsTracing powerToolsTracing) {
    }

    @Around(value="callAt(powerToolsTracing) && execution(@PowertoolsTracing * *.*(..))", argNames="pjp,powerToolsTracing")
    public Object around(ProceedingJoinPoint pjp, PowertoolsTracing powerToolsTracing) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        Subsegment segment = AWSXRay.beginSubsegment((String)("## " + pjp.getSignature().getName()));
        segment.setNamespace(this.namespace(powerToolsTracing));
        if (this.placedOnHandlerMethod(pjp)) {
            segment.putAnnotation("ColdStart", Boolean.valueOf(LambdaHandlerProcessor.isColdStart() == null));
        }
        try {
            Object methodReturn = pjp.proceed(proceedArgs);
            if (powerToolsTracing.captureResponse()) {
                segment.putMetadata(this.namespace(powerToolsTracing), String.valueOf(pjp.getSignature().getName()) + " response", methodReturn);
            }
            LambdaHandlerProcessor.coldStartDone();
            Object object = methodReturn;
            return object;
        }
        catch (Exception e) {
            if (powerToolsTracing.captureError()) {
                segment.putMetadata(this.namespace(powerToolsTracing), String.valueOf(pjp.getSignature().getName()) + " error", (Object)e);
            }
            throw e;
        }
        finally {
            AWSXRay.endSubsegment();
        }
    }

    private String namespace(PowertoolsTracing powerToolsTracing) {
        return powerToolsTracing.namespace().isEmpty() ? LambdaHandlerProcessor.serviceName() : powerToolsTracing.namespace();
    }

    private boolean placedOnHandlerMethod(ProceedingJoinPoint pjp) {
        return LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp) && (LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp) || LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp));
    }

    public static LambdaTracingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.tracing.internal.LambdaTracingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            LambdaTracingAspect.ajc$perSingletonInstance = new LambdaTracingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

