/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.transform;

import java.lang.reflect.InvocationTargetException;
import software.amazon.lambda.powertools.parameters.exception.TransformationException;
import software.amazon.lambda.powertools.parameters.transform.BasicTransformer;
import software.amazon.lambda.powertools.parameters.transform.Transformer;

public class TransformationManager {
    private final ThreadLocal<Class<? extends Transformer>> transformer = ThreadLocal.withInitial(() -> null);

    public void setTransformer(Class<? extends Transformer> transformerClass) {
        this.transformer.set(transformerClass);
    }

    public void unsetTransformer() {
        this.transformer.remove();
    }

    public boolean shouldTransform() {
        return this.transformer.get() != null;
    }

    public String performBasicTransformation(String value) {
        Class<? extends Transformer> transformerClass = this.transformer.get();
        if (transformerClass == null) {
            throw new IllegalStateException("You cannot perform a transformation without Transformer, use the provider.withTransformation() method to specify it.");
        }
        if (!BasicTransformer.class.isAssignableFrom(transformerClass)) {
            throw new IllegalStateException("Wrong Transformer for a String, choose a BasicTransformer.");
        }
        try {
            BasicTransformer basicTransformer = (BasicTransformer)transformerClass.getDeclaredConstructor(new Class[0]).newInstance(null);
            return basicTransformer.applyTransformation(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }

    public <T> T performComplexTransformation(String value, Class<T> targetClass) {
        Class<? extends Transformer> transformerClass = this.transformer.get();
        if (transformerClass == null) {
            throw new IllegalStateException("You cannot perform a transformation without Transformer, use the provider.withTransformation() method to specify it.");
        }
        try {
            Transformer complexTransformer = transformerClass.getDeclaredConstructor(new Class[0]).newInstance(null);
            return complexTransformer.applyTransformation(value, targetClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }
}

