/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;
import software.amazon.lambda.powertools.parameters.transform.Transformer;

public class SecretsProvider
extends BaseProvider {
    private final SecretsManagerClient client;

    SecretsProvider(CacheManager cacheManager, SecretsManagerClient client) {
        super(cacheManager);
        this.client = client;
    }

    SecretsProvider(CacheManager cacheManager) {
        this(cacheManager, Builder.createClient());
    }

    @Override
    protected String getValue(String key) {
        GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(key).build();
        String secretValue = this.client.getSecretValue(request).secretString();
        if (secretValue == null) {
            secretValue = new String(Base64.getDecoder().decode(this.client.getSecretValue(request).secretBinary().asByteArray()), StandardCharsets.UTF_8);
        }
        return secretValue;
    }

    @Override
    protected Map<String, String> getMultipleValues(String path) {
        throw new UnsupportedOperationException("Impossible to get multiple values from AWS Secrets Manager");
    }

    @Override
    public SecretsProvider defaultMaxAge(int maxAge, ChronoUnit unit) {
        super.defaultMaxAge(maxAge, unit);
        return this;
    }

    @Override
    public SecretsProvider withMaxAge(int maxAge, ChronoUnit unit) {
        super.withMaxAge(maxAge, unit);
        return this;
    }

    @Override
    public SecretsProvider withTransformation(Class<? extends Transformer> transformerClass) {
        super.withTransformation(transformerClass);
        return this;
    }

    SecretsManagerClient getClient() {
        return this.client;
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private SecretsManagerClient client;
        private CacheManager cacheManager;
        private TransformationManager transformationManager;

        Builder() {
        }

        public SecretsProvider build() {
            if (this.cacheManager == null) {
                throw new IllegalStateException("No CacheManager provided, please provide one");
            }
            if (this.client == null) {
                this.client = Builder.createClient();
            }
            SecretsProvider provider = new SecretsProvider(this.cacheManager, this.client);
            if (this.transformationManager != null) {
                provider.setTransformationManager(this.transformationManager);
            }
            return provider;
        }

        public Builder withClient(SecretsManagerClient client) {
            this.client = client;
            return this;
        }

        private static SecretsManagerClient createClient() {
            SecretsManagerClientBuilder secretsManagerClientBuilder = (SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).region(Region.of((String)System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())));
            String initializationType = System.getenv().get("AWS_LAMBDA_INITIALIZATION_TYPE");
            if (initializationType != null && initializationType.equals("on-demand")) {
                secretsManagerClientBuilder.credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create());
            }
            return (SecretsManagerClient)secretsManagerClientBuilder.build();
        }

        public Builder withCacheManager(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public Builder withTransformationManager(TransformationManager transformationManager) {
            this.transformationManager = transformationManager;
            return this;
        }
    }
}

