/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.internal.BufferManager;
import software.amazon.lambda.powertools.logging.internal.LoggingConstants;
import software.amazon.lambda.powertools.logging.internal.LoggingManager;
import software.amazon.lambda.powertools.logging.internal.LoggingManagerRegistry;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;
import software.amazon.lambda.powertools.utilities.JsonConfig;

public final class PowertoolsLogging {
    private static final Logger LOG = LoggerFactory.getLogger(PowertoolsLogging.class);
    private static final ThreadLocal<Random> SAMPLER = ThreadLocal.withInitial(Random::new);
    private static AtomicBoolean hasBeenInitialized = new AtomicBoolean(false);

    static {
        PowertoolsLogging.initializeLogLevel();
    }

    private PowertoolsLogging() {
    }

    private static void initializeLogLevel() {
        if (LoggingConstants.POWERTOOLS_LOG_LEVEL != null) {
            Level powertoolsLevel = PowertoolsLogging.getLevelFromString(LoggingConstants.POWERTOOLS_LOG_LEVEL);
            if (LoggingConstants.LAMBDA_LOG_LEVEL != null) {
                Level lambdaLevel = PowertoolsLogging.getLevelFromString(LoggingConstants.LAMBDA_LOG_LEVEL);
                if (powertoolsLevel.toInt() < lambdaLevel.toInt()) {
                    LOG.warn("Current log level ({}) does not match AWS Lambda Advanced Logging Controls minimum log level ({}). This can lead to data loss, consider adjusting them.", (Object)LoggingConstants.POWERTOOLS_LOG_LEVEL, (Object)LoggingConstants.LAMBDA_LOG_LEVEL);
                }
            }
            PowertoolsLogging.setLogLevel(powertoolsLevel);
        } else if (LoggingConstants.LAMBDA_LOG_LEVEL != null) {
            PowertoolsLogging.setLogLevel(PowertoolsLogging.getLevelFromString(LoggingConstants.LAMBDA_LOG_LEVEL));
        }
    }

    private static Level getLevelFromString(String level) {
        if (Arrays.stream(Level.values()).anyMatch(slf4jLevel -> slf4jLevel.name().equalsIgnoreCase(level))) {
            return Level.valueOf((String)level.toUpperCase(Locale.ROOT));
        }
        if ("FATAL".equalsIgnoreCase(level)) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    private static void setLogLevel(Level logLevel) {
        LoggingManager loggingManager = LoggingManagerRegistry.getLoggingManager();
        loggingManager.setLogLevel(logLevel);
    }

    public static void flushBuffer() {
        LoggingManager loggingManager = LoggingManagerRegistry.getLoggingManager();
        if (loggingManager instanceof BufferManager) {
            ((BufferManager)((Object)loggingManager)).flushBuffer();
        }
    }

    public static void clearBuffer() {
        LoggingManager loggingManager = LoggingManagerRegistry.getLoggingManager();
        if (loggingManager instanceof BufferManager) {
            ((BufferManager)((Object)loggingManager)).clearBuffer();
        }
    }

    public static void initializeLogging(Context context) {
        PowertoolsLogging.initializeLogging(context, 0.0, null, null);
    }

    public static void initializeLogging(Context context, double samplingRate) {
        PowertoolsLogging.initializeLogging(context, samplingRate, null, null);
    }

    public static void initializeLogging(Context context, String correlationIdPath, Object event) {
        PowertoolsLogging.initializeLogging(context, 0.0, correlationIdPath, event);
    }

    public static void initializeLogging(Context context, double samplingRate, String correlationIdPath, Object event) {
        PowertoolsLogging.addLambdaContextToLoggingContext(context);
        PowertoolsLogging.setLogLevelBasedOnSamplingRate(samplingRate);
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(xRayTraceId -> MDC.put((String)PowertoolsLoggedFields.FUNCTION_TRACE_ID.getName(), (String)xRayTraceId));
        if (correlationIdPath != null && !correlationIdPath.isEmpty() && event != null) {
            PowertoolsLogging.captureCorrelationId(correlationIdPath, event);
        }
    }

    private static synchronized void addLambdaContextToLoggingContext(Context context) {
        if (context != null) {
            PowertoolsLoggedFields.setValuesFromLambdaContext(context).forEach(MDC::put);
        }
        MDC.put((String)PowertoolsLoggedFields.FUNCTION_COLD_START.getName(), (String)(LambdaHandlerProcessor.isColdStart() ? "true" : "false"));
        if (hasBeenInitialized.compareAndSet(false, true)) {
            LambdaHandlerProcessor.coldStartDone();
        }
        MDC.put((String)PowertoolsLoggedFields.SERVICE.getName(), (String)LambdaHandlerProcessor.serviceName());
    }

    private static void setLogLevelBasedOnSamplingRate(double samplingRate) {
        double effectiveSamplingRate = PowertoolsLogging.getEffectiveSamplingRate(samplingRate);
        if (effectiveSamplingRate < 0.0 || effectiveSamplingRate > 1.0) {
            LOG.warn("Skipping sampling rate configuration because of invalid value. Sampling rate: {}", (Object)effectiveSamplingRate);
            return;
        }
        MDC.put((String)PowertoolsLoggedFields.SAMPLING_RATE.getName(), (String)String.valueOf(effectiveSamplingRate));
        if (effectiveSamplingRate == 0.0) {
            return;
        }
        float sample = SAMPLER.get().nextFloat();
        if (effectiveSamplingRate > (double)sample) {
            LoggingManager loggingManager = LoggingManagerRegistry.getLoggingManager();
            loggingManager.setLogLevel(Level.DEBUG);
            LOG.debug("Changed log level to DEBUG based on Sampling configuration. Sampling Rate: {}, Sampler Value: {}.", (Object)effectiveSamplingRate, (Object)Float.valueOf(sample));
        }
    }

    private static double getEffectiveSamplingRate(double samplingRate) {
        String envSampleRate = LoggingConstants.POWERTOOLS_SAMPLING_RATE;
        if (envSampleRate != null) {
            try {
                return Double.parseDouble(envSampleRate);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Skipping sampling rate on environment variable configuration because of invalid value. Sampling rate: {}", (Object)envSampleRate);
            }
        }
        return samplingRate;
    }

    private static void captureCorrelationId(String correlationIdPath, Object event) {
        try {
            JsonNode jsonNode = JsonConfig.get().getObjectMapper().valueToTree(event);
            Expression jmesExpression = JsonConfig.get().getJmesPath().compile(correlationIdPath);
            JsonNode node = (JsonNode)jmesExpression.search((Object)jsonNode);
            String asText = node.asText();
            if (asText != null && !asText.isEmpty()) {
                MDC.put((String)PowertoolsLoggedFields.CORRELATION_ID.getName(), (String)asText);
            } else {
                LOG.warn("Unable to extract any correlation id. Is your function expecting supported event type?");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to capture correlation id from event.", (Throwable)e);
        }
    }

    public static void clearState(boolean clearMdcState) {
        if (clearMdcState) {
            MDC.clear();
        }
        PowertoolsLogging.clearBuffer();
        SAMPLER.remove();
    }

    public static <T> T withLogging(Context context, Supplier<T> supplier) {
        PowertoolsLogging.initializeLogging(context);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            PowertoolsLogging.clearState(true);
        }
    }

    public static <T> T withLogging(Context context, double samplingRate, Supplier<T> supplier) {
        PowertoolsLogging.initializeLogging(context, samplingRate);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            PowertoolsLogging.clearState(true);
        }
    }

    public static <T> T withLogging(Context context, String correlationIdPath, Object event, Supplier<T> supplier) {
        PowertoolsLogging.initializeLogging(context, correlationIdPath, event);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            PowertoolsLogging.clearState(true);
        }
    }

    public static <T> T withLogging(Context context, double samplingRate, String correlationIdPath, Object event, Supplier<T> supplier) {
        PowertoolsLogging.initializeLogging(context, samplingRate, correlationIdPath, event);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            PowertoolsLogging.clearState(true);
        }
    }
}

