/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.argument;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;

class MapArgument
implements StructuredArgument {
    private final Map<?, ?> map;

    public MapArgument(Map<?, ?> map) {
        this.map = map != null ? new HashMap(map) : null;
    }

    @Override
    public void writeTo(JsonSerializer serializer) {
        if (this.map != null) {
            Iterator<Map.Entry<?, ?>> entries = this.map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<?, ?> entry = entries.next();
                serializer.writeObjectField(String.valueOf(entry.getKey()), entry.getValue());
                if (!entries.hasNext()) continue;
                serializer.writeSeparator();
            }
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.map);
    }
}

