/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.argument;

import java.util.Objects;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.argument.StructuredArguments;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;

class ArrayArgument
implements StructuredArgument {
    private final String key;
    private final Object[] values;

    public ArrayArgument(String key, Object[] values) {
        this.key = Objects.requireNonNull(key, "Key must not be null");
        this.values = new Object[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    @Override
    public void writeTo(JsonSerializer serializer) {
        serializer.writeFieldName(this.key);
        serializer.writeObject(this.values);
    }

    @Override
    public String toString() {
        return String.valueOf(this.key) + "=" + StructuredArguments.toString(this.values);
    }
}

