/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.ServiceLoader;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.Logging;
import software.amazon.lambda.powertools.logging.argument.StructuredArguments;
import software.amazon.lambda.powertools.logging.internal.DefautlLoggingManager;
import software.amazon.lambda.powertools.logging.internal.LoggingConstants;
import software.amazon.lambda.powertools.logging.internal.LoggingManager;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;
import software.amazon.lambda.powertools.utilities.JsonConfig;

@Aspect
@DeclarePrecedence(value="*, software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect")
public final class LambdaLoggingAspect {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaLoggingAspect.class);
    private static final Random SAMPLER = new Random();
    private static Level LEVEL_AT_INITIALISATION;
    private static final LoggingManager LOGGING_MANAGER;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaLoggingAspect ajc$perSingletonInstance;

    static {
        LOGGING_MANAGER = LambdaLoggingAspect.getLoggingManagerFromServiceLoader();
        LambdaLoggingAspect.setLogLevel();
        LEVEL_AT_INITIALISATION = LOGGING_MANAGER.getLogLevel(LOG);
        try {
            LambdaLoggingAspect.ajc$perSingletonInstance = new LambdaLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    static void setLogLevel() {
        if (LoggingConstants.POWERTOOLS_LOG_LEVEL != null) {
            Level powertoolsLevel = LambdaLoggingAspect.getLevelFromString(LoggingConstants.POWERTOOLS_LOG_LEVEL);
            if (LoggingConstants.LAMBDA_LOG_LEVEL != null) {
                Level lambdaLevel = LambdaLoggingAspect.getLevelFromString(LoggingConstants.LAMBDA_LOG_LEVEL);
                if (powertoolsLevel.toInt() < lambdaLevel.toInt()) {
                    LOG.warn("Current log level ({}) does not match AWS Lambda Advanced Logging Controls minimum log level ({}). This can lead to data loss, consider adjusting them.", (Object)LoggingConstants.POWERTOOLS_LOG_LEVEL, (Object)LoggingConstants.LAMBDA_LOG_LEVEL);
                }
            }
            LambdaLoggingAspect.setLogLevels(powertoolsLevel);
        } else if (LoggingConstants.LAMBDA_LOG_LEVEL != null) {
            LambdaLoggingAspect.setLogLevels(LambdaLoggingAspect.getLevelFromString(LoggingConstants.LAMBDA_LOG_LEVEL));
        }
    }

    private static Level getLevelFromString(String level) {
        if (Arrays.stream(Level.values()).anyMatch(slf4jLevel -> slf4jLevel.name().equalsIgnoreCase(level))) {
            return Level.valueOf((String)level.toUpperCase());
        }
        if ("FATAL".equalsIgnoreCase(level)) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    private static LoggingManager getLoggingManagerFromServiceLoader() {
        ServiceLoader loggingManagers;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            loggingManagers = ServiceLoader.load(LoggingManager.class);
        } else {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(LoggingManager.class);
            loggingManagers = AccessController.doPrivileged(action);
        }
        ArrayList<LoggingManager> loggingManagerList = new ArrayList<LoggingManager>();
        for (LoggingManager lm : loggingManagers) {
            loggingManagerList.add(lm);
        }
        return LambdaLoggingAspect.getLoggingManager(loggingManagerList, System.err);
    }

    static LoggingManager getLoggingManager(List<LoggingManager> loggingManagerList, PrintStream printStream) {
        LoggingManager loggingManager;
        if (loggingManagerList.isEmpty()) {
            printStream.println("ERROR. No LoggingManager was found on the classpath");
            printStream.println("ERROR. Applying default LoggingManager: POWERTOOLS_LOG_LEVEL variable is ignored");
            printStream.println("ERROR. Make sure to add either powertools-logging-log4j or powertools-logging-logback to your dependencies");
            loggingManager = new DefautlLoggingManager();
        } else {
            if (loggingManagerList.size() > 1) {
                printStream.println("WARN. Multiple LoggingManagers were found on the classpath");
                for (LoggingManager manager : loggingManagerList) {
                    printStream.println("WARN. Found LoggingManager: [" + manager + "]");
                }
                printStream.println("WARN. Make sure to have only one of powertools-logging-log4j OR powertools-logging-logback to your dependencies");
                printStream.println("WARN. Using the first LoggingManager found on the classpath: [" + loggingManagerList.get(0) + "]");
            }
            loggingManager = loggingManagerList.get(0);
        }
        return loggingManager;
    }

    private static void setLogLevels(Level logLevel) {
        LOGGING_MANAGER.setLogLevel(logLevel);
    }

    @Pointcut(value="@annotation(logging)")
    public /* synthetic */ void callAt(Logging logging) {
    }

    @Around(value="callAt(logging) && execution(@Logging * *.*(..))", argNames="pjp,logging")
    public Object around(ProceedingJoinPoint pjp, Logging logging) throws Throwable {
        Object lambdaFunctionResponse;
        boolean isOnRequestHandler = LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp);
        boolean isOnRequestStreamHandler = LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp);
        this.setLogLevelBasedOnSamplingRate(pjp, logging);
        this.addLambdaContextToLoggingContext(pjp);
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(xRayTraceId -> MDC.put((String)PowertoolsLoggedFields.FUNCTION_TRACE_ID.getName(), (String)xRayTraceId));
        Object[] proceedArgs = this.logEvent(pjp, logging, isOnRequestHandler, isOnRequestStreamHandler);
        if (!logging.correlationIdPath().isEmpty()) {
            this.captureCorrelationId(logging.correlationIdPath(), proceedArgs, isOnRequestHandler, isOnRequestStreamHandler);
        }
        OutputStream backupOutputStream = null;
        if ((logging.logResponse() || LoggingConstants.POWERTOOLS_LOG_RESPONSE) && isOnRequestStreamHandler) {
            backupOutputStream = (OutputStream)proceedArgs[1];
            proceedArgs[1] = new ByteArrayOutputStream();
        }
        try {
            try {
                lambdaFunctionResponse = pjp.proceed(proceedArgs);
            }
            catch (Throwable t) {
                if (logging.logError() || LoggingConstants.POWERTOOLS_LOG_ERROR) {
                    this.logger(pjp).error(MarkerFactory.getMarker((String)"FATAL"), "Exception in Lambda Handler", t);
                }
                throw t;
            }
        }
        finally {
            if (logging.clearState()) {
                MDC.clear();
            }
            LambdaHandlerProcessor.coldStartDone();
        }
        if (logging.logResponse() || LoggingConstants.POWERTOOLS_LOG_RESPONSE) {
            if (isOnRequestHandler) {
                this.logRequestHandlerResponse(pjp, lambdaFunctionResponse);
            } else if (isOnRequestStreamHandler && backupOutputStream != null) {
                byte[] bytes = ((ByteArrayOutputStream)proceedArgs[1]).toByteArray();
                this.logRequestStreamHandlerResponse(pjp, bytes);
                backupOutputStream.write(bytes);
            }
        }
        return lambdaFunctionResponse;
    }

    private Object[] logEvent(ProceedingJoinPoint pjp, Logging logging, boolean isOnRequestHandler, boolean isOnRequestStreamHandler) {
        Object[] proceedArgs = pjp.getArgs();
        if (logging.logEvent() || LoggingConstants.POWERTOOLS_LOG_EVENT) {
            if (isOnRequestHandler) {
                this.logRequestHandlerEvent(pjp, pjp.getArgs()[0]);
            } else if (isOnRequestStreamHandler) {
                proceedArgs = this.logRequestStreamHandlerEvent(pjp);
            }
        }
        return proceedArgs;
    }

    private void addLambdaContextToLoggingContext(ProceedingJoinPoint pjp) {
        Context extractedContext = LambdaHandlerProcessor.extractContext((ProceedingJoinPoint)pjp);
        if (extractedContext != null) {
            PowertoolsLoggedFields.setValuesFromLambdaContext(extractedContext).forEach(MDC::put);
            MDC.put((String)PowertoolsLoggedFields.FUNCTION_COLD_START.getName(), (String)(LambdaHandlerProcessor.isColdStart() ? "true" : "false"));
            MDC.put((String)PowertoolsLoggedFields.SERVICE.getName(), (String)LambdaHandlerProcessor.serviceName());
        }
    }

    private void setLogLevelBasedOnSamplingRate(ProceedingJoinPoint pjp, Logging logging) {
        double samplingRate = this.samplingRate(logging);
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            if (samplingRate < 0.0 || samplingRate > 1.0) {
                LOG.warn("Skipping sampling rate configuration because of invalid value. Sampling rate: {}", (Object)samplingRate);
                return;
            }
            MDC.put((String)PowertoolsLoggedFields.SAMPLING_RATE.getName(), (String)String.valueOf(samplingRate));
            if (samplingRate == 0.0) {
                return;
            }
            float sample = SAMPLER.nextFloat();
            if (samplingRate > (double)sample) {
                LambdaLoggingAspect.setLogLevels(Level.DEBUG);
                LOG.debug("Changed log level to DEBUG based on Sampling configuration. Sampling Rate: {}, Sampler Value: {}.", (Object)samplingRate, (Object)Float.valueOf(sample));
            } else if (LEVEL_AT_INITIALISATION != LOGGING_MANAGER.getLogLevel(LOG)) {
                LambdaLoggingAspect.setLogLevels(LEVEL_AT_INITIALISATION);
            }
        }
    }

    private double samplingRate(Logging logging) {
        String sampleRate = LoggingConstants.POWERTOOLS_SAMPLING_RATE;
        if (sampleRate != null) {
            try {
                return Double.parseDouble(sampleRate);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Skipping sampling rate on environment variable configuration because of invalid value. Sampling rate: {}", (Object)sampleRate);
            }
        }
        return logging.samplingRate();
    }

    private void logRequestHandlerEvent(ProceedingJoinPoint pjp, Object event) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Event", (Object)StructuredArguments.entry("event", event));
        }
    }

    private Object[] logRequestStreamHandlerEvent(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            try {
                byte[] bytes = this.bytesFromInputStreamSafely((InputStream)pjp.getArgs()[0]);
                args[0] = new ByteArrayInputStream(bytes);
                log.info("Handler Event", (Object)StructuredArguments.entry("event", new String(bytes, StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                LOG.warn("Failed to log event from supplied input stream.", (Throwable)e);
            }
        }
        return args;
    }

    private void logRequestHandlerResponse(ProceedingJoinPoint pjp, Object response) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Response", (Object)StructuredArguments.entry("response", response));
        }
    }

    private void logRequestStreamHandlerResponse(ProceedingJoinPoint pjp, byte[] bytes) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Response", (Object)StructuredArguments.entry("response", new String(bytes, StandardCharsets.UTF_8)));
        }
    }

    private void captureCorrelationId(String correlationIdPath, Object[] proceedArgs, boolean isOnRequestHandler, boolean isOnRequestStreamHandler) {
        if (isOnRequestHandler) {
            JsonNode jsonNode = JsonConfig.get().getObjectMapper().valueToTree(proceedArgs[0]);
            this.setCorrelationIdFromNode(correlationIdPath, jsonNode);
        } else if (isOnRequestStreamHandler) {
            try {
                byte[] bytes = this.bytesFromInputStreamSafely((InputStream)proceedArgs[0]);
                JsonNode jsonNode = JsonConfig.get().getObjectMapper().readTree(bytes);
                proceedArgs[0] = new ByteArrayInputStream(bytes);
                this.setCorrelationIdFromNode(correlationIdPath, jsonNode);
            }
            catch (IOException e) {
                LOG.warn("Failed to capture correlation id on event from supplied input stream.", (Throwable)e);
            }
        }
    }

    private void setCorrelationIdFromNode(String correlationIdPath, JsonNode jsonNode) {
        Expression jmesExpression = JsonConfig.get().getJmesPath().compile(correlationIdPath);
        JsonNode node = (JsonNode)jmesExpression.search((Object)jsonNode);
        String asText = node.asText();
        if (asText != null && !asText.isEmpty()) {
            MDC.put((String)PowertoolsLoggedFields.CORRELATION_ID.getName(), (String)asText);
        } else {
            LOG.warn("Unable to extract any correlation id. Is your function expecting supported event type?");
        }
    }

    /*
     * Loose catch block
     */
    private byte[] bytesFromInputStreamSafely(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            byte[] byArray;
            InputStreamReader reader;
            ByteArrayOutputStream out;
            block17: {
                block16: {
                    int n;
                    out = new ByteArrayOutputStream();
                    reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                    char[] buffer = new char[4096];
                    while (-1 != (n = reader.read(buffer))) {
                        writer.write(buffer, 0, n);
                    }
                    writer.flush();
                    byArray = out.toByteArray();
                    if (reader == null) break block16;
                    reader.close();
                }
                if (out == null) break block17;
                out.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (out != null) {
                            out.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Logger logger(ProceedingJoinPoint pjp) {
        return LoggerFactory.getLogger((Class)pjp.getSignature().getDeclaringType());
    }

    public static LambdaLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

