/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages.internal;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessor;

class LargeSQSMessageProcessor
extends LargeMessageProcessor<SQSEvent.SQSMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(LargeSQSMessageProcessor.class);
    private static final String LEGACY_RESERVED_ATTRIBUTE_NAME = "SQSLargePayloadSize";
    private static final int INTEGER_SIZE_IN_BYTES = 4;
    private static final byte STRING_TYPE_FIELD_INDEX = 1;
    private static final byte BINARY_TYPE_FIELD_INDEX = 2;
    private static final byte STRING_LIST_TYPE_FIELD_INDEX = 3;
    private static final byte BINARY_LIST_TYPE_FIELD_INDEX = 4;

    LargeSQSMessageProcessor() {
    }

    static Optional<String> calculateMessageBodyMd5(String messageBody) {
        byte[] expectedMd5;
        try {
            expectedMd5 = Md5Utils.computeMD5Hash((byte[])messageBody.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOG.warn("Unable to calculate the MD5 hash of the message body. ", (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(BinaryUtils.toHex((byte[])expectedMd5));
    }

    static Optional<String> calculateMessageAttributesMd5(Map<String, SQSEvent.MessageAttribute> messageAttributes) {
        MessageDigest md5Digest;
        ArrayList<String> sortedAttributeNames = new ArrayList<String>(messageAttributes.keySet());
        Collections.sort(sortedAttributeNames);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
            for (String attrName : sortedAttributeNames) {
                SQSEvent.MessageAttribute attrValue = messageAttributes.get(attrName);
                LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, attrName);
                LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, attrValue.getDataType());
                if (attrValue.getStringValue() != null) {
                    md5Digest.update((byte)1);
                    LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, attrValue.getStringValue());
                    continue;
                }
                if (attrValue.getBinaryValue() != null) {
                    md5Digest.update((byte)2);
                    LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, attrValue.getBinaryValue());
                    continue;
                }
                if (attrValue.getStringListValues() != null && attrValue.getStringListValues().size() > 0) {
                    md5Digest.update((byte)3);
                    for (String strListMember : attrValue.getStringListValues()) {
                        LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, strListMember);
                    }
                    continue;
                }
                if (attrValue.getBinaryListValues() == null || attrValue.getBinaryListValues().size() <= 0) continue;
                md5Digest.update((byte)4);
                for (ByteBuffer byteListMember : attrValue.getBinaryListValues()) {
                    LargeSQSMessageProcessor.updateLengthAndBytes(md5Digest, byteListMember);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to calculate the MD5 hash of the message attributes. ", (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(BinaryUtils.toHex((byte[])md5Digest.digest()));
    }

    private static void updateLengthAndBytes(MessageDigest digest, String str) {
        byte[] utf8Encoded = str.getBytes(StandardCharsets.UTF_8);
        ByteBuffer lengthBytes = ByteBuffer.allocate(4).putInt(utf8Encoded.length);
        digest.update(lengthBytes.array());
        digest.update(utf8Encoded);
    }

    private static void updateLengthAndBytes(MessageDigest digest, ByteBuffer binaryValue) {
        ByteBuffer readOnlyBuffer = binaryValue.asReadOnlyBuffer();
        int size = readOnlyBuffer.remaining();
        ByteBuffer lengthBytes = ByteBuffer.allocate(4).putInt(size);
        digest.update(lengthBytes.array());
        digest.update(readOnlyBuffer);
    }

    @Override
    protected String getMessageId(SQSEvent.SQSMessage message) {
        return message.getMessageId();
    }

    @Override
    protected String getMessageContent(SQSEvent.SQSMessage message) {
        return message.getBody();
    }

    @Override
    protected void updateMessageContent(SQSEvent.SQSMessage message, String messageContent) {
        message.setBody(messageContent);
        message.setMd5OfBody(LargeSQSMessageProcessor.calculateMessageBodyMd5(messageContent).orElse(message.getMd5OfBody()));
    }

    @Override
    protected boolean isLargeMessage(SQSEvent.SQSMessage message) {
        Map msgAttributes = message.getMessageAttributes();
        return msgAttributes != null && (msgAttributes.containsKey("ExtendedPayloadSize") || msgAttributes.containsKey(LEGACY_RESERVED_ATTRIBUTE_NAME));
    }

    @Override
    protected void removeLargeMessageAttributes(SQSEvent.SQSMessage message) {
        HashMap<String, SQSEvent.MessageAttribute> newAttributes = new HashMap<String, SQSEvent.MessageAttribute>(message.getMessageAttributes());
        newAttributes.remove("ExtendedPayloadSize");
        newAttributes.remove(LEGACY_RESERVED_ATTRIBUTE_NAME);
        message.setMessageAttributes(newAttributes);
        message.setMd5OfMessageAttributes(LargeSQSMessageProcessor.calculateMessageAttributesMd5(newAttributes).orElse(message.getMd5OfMessageAttributes()));
    }
}

