/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages.internal;

import java.util.Optional;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.largemessages.LargeMessage;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessor;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessorFactory;

@Aspect
public class LargeMessageAspect {
    private static final Logger LOG = LoggerFactory.getLogger(LargeMessageAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LargeMessageAspect ajc$perSingletonInstance;

    static {
        try {
            LargeMessageAspect.ajc$perSingletonInstance = new LargeMessageAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(largeMessage)")
    public /* synthetic */ void callAt(LargeMessage largeMessage) {
    }

    @Around(value="callAt(largeMessage) && execution(@LargeMessage * *.*(..))", argNames="pjp,largeMessage")
    public Object around(ProceedingJoinPoint pjp, LargeMessage largeMessage) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        if (proceedArgs.length == 0) {
            LargeMessageAspect.LOG.warn("@LargeMessage annotation is placed on a method without any message to process, proceeding");
            return pjp.proceed(proceedArgs);
        }
        Object message = proceedArgs[0];
        Optional<LargeMessageProcessor<?>> largeMessageProcessor = LargeMessageProcessorFactory.get(message);
        if (!largeMessageProcessor.isPresent()) {
            LargeMessageAspect.LOG.warn("@LargeMessage annotation is placed on a method with unsupported message type [{}], proceeding", message.getClass());
            return pjp.proceed(proceedArgs);
        }
        return largeMessageProcessor.get().process(message, msg -> pjp.proceed(proceedArgs), largeMessage.deleteS3Object());
    }

    public static LargeMessageAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.largemessages.internal.LargeMessageAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

