/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages;

import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.largemessages.LargeMessageProcessingException;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessor;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessorFactory;

public final class LargeMessages {
    private static final Logger LOG = LoggerFactory.getLogger(LargeMessages.class);

    private LargeMessages() {
    }

    public static <T, R> R processLargeMessage(T message, Function<T, R> function) {
        return LargeMessages.processLargeMessage(message, function, true);
    }

    public static <T, R> R processLargeMessage(T message, Function<T, R> function, boolean deleteS3Object) {
        Optional<LargeMessageProcessor<?>> processor = LargeMessageProcessorFactory.get(message);
        if (!processor.isPresent()) {
            LOG.warn("Unsupported message type [{}], proceeding without large message processing", message.getClass());
            return function.apply(message);
        }
        try {
            LargeMessageProcessor<?> typedProcessor = processor.get();
            return (R)typedProcessor.process(message, function::apply, deleteS3Object);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LargeMessageProcessingException("Failed to process large message", t);
        }
    }
}

