/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.retrieval.GetRecordsRetrievalStrategy;
import software.amazon.kinesis.retrieval.polling.KinesisDataFetcher;

@KinesisClientInternalApi
public class SynchronousGetRecordsRetrievalStrategy
implements GetRecordsRetrievalStrategy {
    @NonNull
    private final KinesisDataFetcher dataFetcher;

    @Override
    public GetRecordsResponse getRecords(int maxRecords) {
        return this.dataFetcher.getRecords().accept();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public KinesisDataFetcher getDataFetcher() {
        return this.dataFetcher;
    }

    public SynchronousGetRecordsRetrievalStrategy(@NonNull KinesisDataFetcher dataFetcher) {
        if (dataFetcher == null) {
            throw new NullPointerException("dataFetcher");
        }
        this.dataFetcher = dataFetcher;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousGetRecordsRetrievalStrategy)) {
            return false;
        }
        SynchronousGetRecordsRetrievalStrategy other = (SynchronousGetRecordsRetrievalStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisDataFetcher this$dataFetcher = this.getDataFetcher();
        KinesisDataFetcher other$dataFetcher = other.getDataFetcher();
        return !(this$dataFetcher == null ? other$dataFetcher != null : !this$dataFetcher.equals(other$dataFetcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousGetRecordsRetrievalStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisDataFetcher $dataFetcher = this.getDataFetcher();
        result = result * 59 + ($dataFetcher == null ? 43 : $dataFetcher.hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousGetRecordsRetrievalStrategy(dataFetcher=" + this.getDataFetcher() + ")";
    }
}

