/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;

public class MetricsUtil {
    public static final String OPERATION_DIMENSION_NAME = "Operation";
    public static final String SHARD_ID_DIMENSION_NAME = "ShardId";
    private static final String WORKER_IDENTIFIER_DIMENSION = "WorkerIdentifier";
    private static final String TIME_METRIC = "Time";
    private static final String SUCCESS_METRIC = "Success";

    public static MetricsScope createMetrics(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return MetricsUtil.createMetricScope(metricsFactory, null);
    }

    public static MetricsScope createMetricsWithOperation(@NonNull MetricsFactory metricsFactory, @NonNull String operation) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        return MetricsUtil.createMetricScope(metricsFactory, operation);
    }

    private static MetricsScope createMetricScope(MetricsFactory metricsFactory, String operation) {
        MetricsScope metricsScope = metricsFactory.createMetrics();
        if (StringUtils.isNotEmpty((String)operation)) {
            metricsScope.addDimension(OPERATION_DIMENSION_NAME, operation);
        }
        return metricsScope;
    }

    public static void addShardId(@NonNull MetricsScope metricsScope, @NonNull String shardId) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        MetricsUtil.addOperation(metricsScope, SHARD_ID_DIMENSION_NAME, shardId);
    }

    public static void addWorkerIdentifier(@NonNull MetricsScope metricsScope, @NonNull String workerIdentifier) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (workerIdentifier == null) {
            throw new NullPointerException("workerIdentifier");
        }
        MetricsUtil.addOperation(metricsScope, WORKER_IDENTIFIER_DIMENSION, workerIdentifier);
    }

    public static void addOperation(@NonNull MetricsScope metricsScope, @NonNull String dimension, @NonNull String value) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        metricsScope.addDimension(dimension, value);
    }

    public static void addSuccessAndLatency(@NonNull MetricsScope metricsScope, boolean success, long startTime, @NonNull MetricsLevel metricsLevel) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (metricsLevel == null) {
            throw new NullPointerException("metricsLevel");
        }
        MetricsUtil.addSuccessAndLatency(metricsScope, null, success, startTime, metricsLevel);
    }

    public static void addSuccessAndLatency(@NonNull MetricsScope metricsScope, String dimension, boolean success, long startTime, @NonNull MetricsLevel metricsLevel) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (metricsLevel == null) {
            throw new NullPointerException("metricsLevel");
        }
        MetricsUtil.addSuccess(metricsScope, dimension, success, metricsLevel);
        MetricsUtil.addLatency(metricsScope, dimension, startTime, metricsLevel);
    }

    public static void addLatency(@NonNull MetricsScope metricsScope, String dimension, long startTime, @NonNull MetricsLevel metricsLevel) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (metricsLevel == null) {
            throw new NullPointerException("metricsLevel");
        }
        String metricName = StringUtils.isEmpty((String)dimension) ? TIME_METRIC : String.format("%s.%s", dimension, TIME_METRIC);
        metricsScope.addData(metricName, System.currentTimeMillis() - startTime, StandardUnit.MILLISECONDS, metricsLevel);
    }

    public static void addSuccess(@NonNull MetricsScope metricsScope, String dimension, boolean success, @NonNull MetricsLevel metricsLevel) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        if (metricsLevel == null) {
            throw new NullPointerException("metricsLevel");
        }
        String metricName = StringUtils.isEmpty((String)dimension) ? SUCCESS_METRIC : String.format("%s.%s", dimension, SUCCESS_METRIC);
        metricsScope.addData(metricName, success ? 1.0 : 0.0, StandardUnit.COUNT, metricsLevel);
    }

    public static void endScope(@NonNull MetricsScope metricsScope) {
        if (metricsScope == null) {
            throw new NullPointerException("metricsScope");
        }
        metricsScope.end();
    }
}

