/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;

public abstract class InterceptingMetricsFactory
implements MetricsFactory {
    private final MetricsFactory other;

    public InterceptingMetricsFactory(MetricsFactory other) {
        this.other = other;
    }

    @Override
    public MetricsScope createMetrics() {
        MetricsScope otherScope = this.other.createMetrics();
        this.interceptCreateMetrics(otherScope);
        return new InterceptingMetricsScope(otherScope);
    }

    protected void interceptCreateMetrics(MetricsScope scope) {
    }

    protected void interceptAddData(String name, double value, StandardUnit unit, MetricsScope scope) {
        scope.addData(name, value, unit);
    }

    protected void interceptAddData(String name, double value, StandardUnit unit, MetricsLevel level, MetricsScope scope) {
        scope.addData(name, value, unit, level);
    }

    protected void interceptAddDimension(String name, String value, MetricsScope scope) {
        scope.addDimension(name, value);
    }

    protected void interceptEnd(MetricsScope scope) {
        scope.end();
    }

    private class InterceptingMetricsScope
    implements MetricsScope {
        private MetricsScope other;

        public InterceptingMetricsScope(MetricsScope other) {
            this.other = other;
        }

        @Override
        public void addData(String name, double value, StandardUnit unit) {
            InterceptingMetricsFactory.this.interceptAddData(name, value, unit, this.other);
        }

        @Override
        public void addData(String name, double value, StandardUnit unit, MetricsLevel level) {
            InterceptingMetricsFactory.this.interceptAddData(name, value, unit, level, this.other);
        }

        @Override
        public void addDimension(String name, String value) {
            InterceptingMetricsFactory.this.interceptAddDimension(name, value, this.other);
        }

        @Override
        public void end() {
            InterceptingMetricsFactory.this.interceptEnd(this.other);
        }
    }
}

