/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.metrics.CloudWatchMetricKey;
import software.amazon.kinesis.metrics.CloudWatchMetricsPublisher;
import software.amazon.kinesis.metrics.MetricAccumulatingQueue;
import software.amazon.kinesis.metrics.MetricDatumWithKey;

public class CloudWatchPublisherRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchPublisherRunnable.class);
    private final CloudWatchMetricsPublisher metricsPublisher;
    private final MetricAccumulatingQueue<CloudWatchMetricKey> queue;
    private final long bufferTimeMillis;
    private int flushSize;
    private boolean shuttingDown = false;
    private boolean shutdown = false;
    private long lastFlushTime = Long.MAX_VALUE;
    private int maxJitter;
    private Random rand = new Random();
    private int nextJitterValueToUse = 0;

    public CloudWatchPublisherRunnable(CloudWatchMetricsPublisher metricsPublisher, long bufferTimeMillis, int maxQueueSize, int batchSize) {
        this(metricsPublisher, bufferTimeMillis, maxQueueSize, batchSize, 0);
    }

    public CloudWatchPublisherRunnable(CloudWatchMetricsPublisher metricsPublisher, long bufferTimeMillis, int maxQueueSize, int batchSize, int maxJitter) {
        if (log.isDebugEnabled()) {
            log.debug("Constructing CloudWatchPublisherRunnable with maxBufferTimeMillis {} maxQueueSize {} batchSize {} maxJitter {}", new Object[]{bufferTimeMillis, maxQueueSize, batchSize, maxJitter});
        }
        this.metricsPublisher = metricsPublisher;
        this.bufferTimeMillis = bufferTimeMillis;
        this.queue = new MetricAccumulatingQueue(maxQueueSize);
        this.flushSize = batchSize;
        this.maxJitter = maxJitter;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.runOnce();
            }
            catch (Throwable t) {
                log.error("Encountered throwable in CWPublisherRunable", t);
            }
        }
        log.info("CWPublication thread finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce() {
        List<MetricDatumWithKey<CloudWatchMetricKey>> dataToPublish = null;
        MetricAccumulatingQueue<CloudWatchMetricKey> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            long timeSinceFlush = Math.max(0L, this.getTime() - this.lastFlushTime);
            if (timeSinceFlush >= this.bufferTimeMillis || this.queue.size() >= this.flushSize || this.shuttingDown) {
                dataToPublish = this.queue.drain(this.flushSize);
                if (log.isDebugEnabled()) {
                    log.debug("Drained {} datums from queue", (Object)dataToPublish.size());
                }
                if (this.shuttingDown) {
                    if (log.isDebugEnabled()) {
                        log.debug("Shutting down with {} datums left on the queue", (Object)this.queue.size());
                    }
                    this.shutdown = this.queue.isEmpty();
                }
            } else {
                long waitTime = this.bufferTimeMillis - timeSinceFlush;
                if (log.isDebugEnabled()) {
                    log.debug("Waiting up to {} ms for {} more datums to appear.", (Object)waitTime, (Object)(this.flushSize - this.queue.size()));
                }
                try {
                    this.queue.wait(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (dataToPublish != null) {
            try {
                this.metricsPublisher.publishMetrics(dataToPublish);
            }
            catch (Throwable t) {
                log.error("Caught exception thrown by metrics Publisher in CloudWatchPublisherRunnable", t);
            }
            this.lastFlushTime = this.getTime() + (long)this.nextJitterValueToUse;
            if (this.maxJitter != 0) {
                this.nextJitterValueToUse = this.maxJitter - this.rand.nextInt(2 * this.maxJitter);
            }
        }
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CWPublication thread.");
        MetricAccumulatingQueue<CloudWatchMetricKey> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            this.shuttingDown = true;
            this.queue.notify();
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Collection<MetricDatumWithKey<CloudWatchMetricKey>> data) {
        MetricAccumulatingQueue<CloudWatchMetricKey> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            if (this.shuttingDown) {
                log.warn("Dropping metrics {} because CloudWatchPublisherRunnable is shutting down.", data);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Enqueueing {} datums for publication", (Object)data.size());
            }
            for (MetricDatumWithKey<CloudWatchMetricKey> datumWithKey : data) {
                if (this.queue.offer((CloudWatchMetricKey)datumWithKey.key, datumWithKey.datum)) continue;
                log.warn("Metrics queue full - dropping metric {}", (Object)datumWithKey.datum);
            }
            if (this.lastFlushTime == Long.MAX_VALUE) {
                this.lastFlushTime = this.getTime();
            }
            this.queue.notify();
        }
    }
}

