/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.checkpoint.ShardRecordProcessorCheckpointer;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.leases.ShardSyncer;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.ShutdownInput;
import software.amazon.kinesis.lifecycle.ShutdownReason;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.lifecycle.events.LeaseLostInput;
import software.amazon.kinesis.lifecycle.events.ShardEndedInput;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.processor.ShardRecordProcessor;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class ShutdownTask
implements ConsumerTask {
    private static final Logger log = LoggerFactory.getLogger(ShutdownTask.class);
    private static final String SHUTDOWN_TASK_OPERATION = "ShutdownTask";
    private static final String RECORD_PROCESSOR_SHUTDOWN_METRIC = "RecordProcessor.shutdown";
    @NonNull
    private final ShardInfo shardInfo;
    @NonNull
    private final ShardDetector shardDetector;
    @NonNull
    private final ShardRecordProcessor shardRecordProcessor;
    @NonNull
    private final ShardRecordProcessorCheckpointer recordProcessorCheckpointer;
    @NonNull
    private final ShutdownReason reason;
    @NonNull
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final boolean cleanupLeasesOfCompletedShards;
    private final boolean ignoreUnexpectedChildShards;
    @NonNull
    private final LeaseRefresher leaseRefresher;
    private final long backoffTimeMillis;
    @NonNull
    private final RecordsPublisher recordsPublisher;
    @NonNull
    private final MetricsFactory metricsFactory;
    private final TaskType taskType = TaskType.SHUTDOWN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        Exception exception;
        this.recordProcessorCheckpointer.checkpointer().operation(SHUTDOWN_TASK_OPERATION);
        MetricsScope scope = MetricsUtil.createMetricsWithOperation(this.metricsFactory, SHUTDOWN_TASK_OPERATION);
        boolean applicationException = false;
        try {
            if (this.reason == ShutdownReason.SHARD_END) {
                this.recordProcessorCheckpointer.sequenceNumberAtShardEnd(this.recordProcessorCheckpointer.largestPermittedCheckpointValue());
                this.recordProcessorCheckpointer.largestPermittedCheckpointValue(ExtendedSequenceNumber.SHARD_END);
            }
            log.debug("Invoking shutdown() for shard {}, concurrencyToken {}. Shutdown reason: {}", new Object[]{this.shardInfo.shardId(), this.shardInfo.concurrencyToken(), this.reason});
            ShutdownInput shutdownInput = ShutdownInput.builder().shutdownReason(this.reason).checkpointer(this.recordProcessorCheckpointer).build();
            long startTime = System.currentTimeMillis();
            try {
                if (this.reason == ShutdownReason.SHARD_END) {
                    this.shardRecordProcessor.shardEnded(ShardEndedInput.builder().checkpointer(this.recordProcessorCheckpointer).build());
                    ExtendedSequenceNumber lastCheckpointValue = this.recordProcessorCheckpointer.lastCheckpointValue();
                    if (lastCheckpointValue == null || !lastCheckpointValue.equals(ExtendedSequenceNumber.SHARD_END)) {
                        throw new IllegalArgumentException("Application didn't checkpoint at end of shard " + this.shardInfo.shardId());
                    }
                } else {
                    this.shardRecordProcessor.leaseLost(LeaseLostInput.builder().build());
                }
                log.debug("Shutting down retrieval strategy.");
                this.recordsPublisher.shutdown();
                log.debug("Record processor completed shutdown() for shard {}", (Object)this.shardInfo.shardId());
            }
            catch (Exception e) {
                applicationException = true;
                throw e;
            }
            finally {
                MetricsUtil.addLatency(scope, RECORD_PROCESSOR_SHUTDOWN_METRIC, startTime, MetricsLevel.SUMMARY);
            }
            if (this.reason == ShutdownReason.SHARD_END) {
                log.debug("Looking for child shards of shard {}", (Object)this.shardInfo.shardId());
                ShardSyncer.checkAndCreateLeasesForNewShards(this.shardDetector, this.leaseRefresher, this.initialPositionInStream, this.cleanupLeasesOfCompletedShards, this.ignoreUnexpectedChildShards, scope);
                log.debug("Finished checking for child shards of shard {}", (Object)this.shardInfo.shardId());
            }
            TaskResult taskResult = new TaskResult(null);
            return taskResult;
        }
        catch (Exception e) {
            if (applicationException) {
                log.error("Application exception. ", (Throwable)e);
            } else {
                log.error("Caught exception: ", (Throwable)e);
            }
            exception = e;
            try {
                Thread.sleep(this.backoffTimeMillis);
            }
            catch (InterruptedException ie) {
                log.debug("Interrupted sleep", (Throwable)ie);
            }
        }
        finally {
            MetricsUtil.endScope(scope);
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    @VisibleForTesting
    public ShutdownReason getReason() {
        return this.reason;
    }

    public ShutdownTask(@NonNull ShardInfo shardInfo, @NonNull ShardDetector shardDetector, @NonNull ShardRecordProcessor shardRecordProcessor, @NonNull ShardRecordProcessorCheckpointer recordProcessorCheckpointer, @NonNull ShutdownReason reason, @NonNull InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, @NonNull LeaseRefresher leaseRefresher, long backoffTimeMillis, @NonNull RecordsPublisher recordsPublisher, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        if (shardRecordProcessor == null) {
            throw new NullPointerException("shardRecordProcessor");
        }
        if (recordProcessorCheckpointer == null) {
            throw new NullPointerException("recordProcessorCheckpointer");
        }
        if (reason == null) {
            throw new NullPointerException("reason");
        }
        if (initialPositionInStream == null) {
            throw new NullPointerException("initialPositionInStream");
        }
        if (leaseRefresher == null) {
            throw new NullPointerException("leaseRefresher");
        }
        if (recordsPublisher == null) {
            throw new NullPointerException("recordsPublisher");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.shardInfo = shardInfo;
        this.shardDetector = shardDetector;
        this.shardRecordProcessor = shardRecordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.reason = reason;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.leaseRefresher = leaseRefresher;
        this.backoffTimeMillis = backoffTimeMillis;
        this.recordsPublisher = recordsPublisher;
        this.metricsFactory = metricsFactory;
    }
}

