/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import java.util.concurrent.CountDownLatch;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.lifecycle.ShutdownNotification;

@KinesisClientInternalApi
public class ShardConsumerShutdownNotification
implements ShutdownNotification {
    private final LeaseCoordinator leaseCoordinator;
    private final Lease lease;
    private final CountDownLatch shutdownCompleteLatch;
    private final CountDownLatch notificationCompleteLatch;
    private boolean notificationComplete = false;
    private boolean allNotificationCompleted = false;

    public ShardConsumerShutdownNotification(LeaseCoordinator leaseCoordinator, Lease lease, CountDownLatch notificationCompleteLatch, CountDownLatch shutdownCompleteLatch) {
        this.leaseCoordinator = leaseCoordinator;
        this.lease = lease;
        this.notificationCompleteLatch = notificationCompleteLatch;
        this.shutdownCompleteLatch = shutdownCompleteLatch;
    }

    @Override
    public void shutdownNotificationComplete() {
        if (this.notificationComplete) {
            return;
        }
        this.leaseCoordinator.dropLease(this.lease);
        this.notificationCompleteLatch.countDown();
        this.notificationComplete = true;
    }

    @Override
    public void shutdownComplete() {
        if (this.allNotificationCompleted) {
            return;
        }
        if (!this.notificationComplete) {
            this.notificationCompleteLatch.countDown();
        }
        this.shutdownCompleteLatch.countDown();
        this.allNotificationCompleted = true;
    }
}

