/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class ShardInfo {
    private final String shardId;
    private final String concurrencyToken;
    private final List<String> parentShardIds;
    private final ExtendedSequenceNumber checkpoint;

    public ShardInfo(@NonNull String shardId, String concurrencyToken, Collection<String> parentShardIds, ExtendedSequenceNumber checkpoint) {
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        this.shardId = shardId;
        this.concurrencyToken = concurrencyToken;
        this.parentShardIds = new LinkedList<String>();
        if (parentShardIds != null) {
            this.parentShardIds.addAll(parentShardIds);
        }
        Collections.sort(this.parentShardIds);
        this.checkpoint = checkpoint;
    }

    public List<String> parentShardIds() {
        return new LinkedList<String>(this.parentShardIds);
    }

    public boolean isCompleted() {
        return ExtendedSequenceNumber.SHARD_END.equals(this.checkpoint);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.concurrencyToken).append(this.parentShardIds).append((Object)this.shardId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShardInfo other = (ShardInfo)obj;
        return new EqualsBuilder().append((Object)this.concurrencyToken, (Object)other.concurrencyToken).append(this.parentShardIds, other.parentShardIds).append((Object)this.shardId, (Object)other.shardId).isEquals();
    }

    public String shardId() {
        return this.shardId;
    }

    public String concurrencyToken() {
        return this.concurrencyToken;
    }

    public ExtendedSequenceNumber checkpoint() {
        return this.checkpoint;
    }

    public String toString() {
        return "ShardInfo(shardId=" + this.shardId() + ", concurrencyToken=" + this.concurrencyToken() + ", parentShardIds=" + this.parentShardIds() + ", checkpoint=" + this.checkpoint() + ")";
    }
}

