/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import java.util.concurrent.CountDownLatch;
import software.amazon.kinesis.coordinator.Scheduler;

class GracefulShutdownContext {
    private final CountDownLatch shutdownCompleteLatch;
    private final CountDownLatch notificationCompleteLatch;
    private final Scheduler scheduler;
    static GracefulShutdownContext SHUTDOWN_ALREADY_COMPLETED = new GracefulShutdownContext(null, null, null);

    boolean isShutdownAlreadyCompleted() {
        return this.shutdownCompleteLatch == null && this.notificationCompleteLatch == null && this.scheduler == null;
    }

    public GracefulShutdownContext(CountDownLatch shutdownCompleteLatch, CountDownLatch notificationCompleteLatch, Scheduler scheduler) {
        this.shutdownCompleteLatch = shutdownCompleteLatch;
        this.notificationCompleteLatch = notificationCompleteLatch;
        this.scheduler = scheduler;
    }

    public CountDownLatch shutdownCompleteLatch() {
        return this.shutdownCompleteLatch;
    }

    public CountDownLatch notificationCompleteLatch() {
        return this.notificationCompleteLatch;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GracefulShutdownContext)) {
            return false;
        }
        GracefulShutdownContext other = (GracefulShutdownContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CountDownLatch this$shutdownCompleteLatch = this.shutdownCompleteLatch();
        CountDownLatch other$shutdownCompleteLatch = other.shutdownCompleteLatch();
        if (this$shutdownCompleteLatch == null ? other$shutdownCompleteLatch != null : !this$shutdownCompleteLatch.equals(other$shutdownCompleteLatch)) {
            return false;
        }
        CountDownLatch this$notificationCompleteLatch = this.notificationCompleteLatch();
        CountDownLatch other$notificationCompleteLatch = other.notificationCompleteLatch();
        if (this$notificationCompleteLatch == null ? other$notificationCompleteLatch != null : !this$notificationCompleteLatch.equals(other$notificationCompleteLatch)) {
            return false;
        }
        Scheduler this$scheduler = this.scheduler();
        Scheduler other$scheduler = other.scheduler();
        return !(this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GracefulShutdownContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CountDownLatch $shutdownCompleteLatch = this.shutdownCompleteLatch();
        result = result * 59 + ($shutdownCompleteLatch == null ? 43 : $shutdownCompleteLatch.hashCode());
        CountDownLatch $notificationCompleteLatch = this.notificationCompleteLatch();
        result = result * 59 + ($notificationCompleteLatch == null ? 43 : $notificationCompleteLatch.hashCode());
        Scheduler $scheduler = this.scheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        return result;
    }

    public String toString() {
        return "GracefulShutdownContext(shutdownCompleteLatch=" + this.shutdownCompleteLatch() + ", notificationCompleteLatch=" + this.notificationCompleteLatch() + ", scheduler=" + this.scheduler() + ")";
    }
}

