/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.DataFetchingStrategy;
import software.amazon.kinesis.retrieval.GetRecordsRetrievalStrategy;
import software.amazon.kinesis.retrieval.RecordsFetcherFactory;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.polling.PrefetchRecordsPublisher;

@KinesisClientInternalApi
public class SimpleRecordsFetcherFactory
implements RecordsFetcherFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleRecordsFetcherFactory.class);
    private int maxPendingProcessRecordsInput = 3;
    private int maxByteSize = 0x800000;
    private int maxRecordsCount = 30000;
    private long idleMillisBetweenCalls = 1500L;
    private DataFetchingStrategy dataFetchingStrategy = DataFetchingStrategy.DEFAULT;

    @Override
    public RecordsPublisher createRecordsFetcher(GetRecordsRetrievalStrategy getRecordsRetrievalStrategy, String shardId, MetricsFactory metricsFactory, int maxRecords) {
        return new PrefetchRecordsPublisher(this.maxPendingProcessRecordsInput, this.maxByteSize, this.maxRecordsCount, maxRecords, getRecordsRetrievalStrategy, Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefetch-cache-" + shardId + "-%04d").build()), this.idleMillisBetweenCalls, metricsFactory, "ProcessTask", shardId);
    }

    @Override
    public void maxPendingProcessRecordsInput(int maxPendingProcessRecordsInput) {
        this.maxPendingProcessRecordsInput = maxPendingProcessRecordsInput;
    }

    @Override
    public void maxByteSize(int maxByteSize) {
        this.maxByteSize = maxByteSize;
    }

    @Override
    public void maxRecordsCount(int maxRecordsCount) {
        this.maxRecordsCount = maxRecordsCount;
    }

    @Override
    public void dataFetchingStrategy(DataFetchingStrategy dataFetchingStrategy) {
        this.dataFetchingStrategy = dataFetchingStrategy;
    }

    @Override
    public void idleMillisBetweenCalls(long idleMillisBetweenCalls) {
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
    }

    @Override
    public int maxPendingProcessRecordsInput() {
        return this.maxPendingProcessRecordsInput;
    }

    @Override
    public int maxByteSize() {
        return this.maxByteSize;
    }

    @Override
    public int maxRecordsCount() {
        return this.maxRecordsCount;
    }

    @Override
    public DataFetchingStrategy dataFetchingStrategy() {
        return this.dataFetchingStrategy;
    }

    @Override
    public long idleMillisBetweenCalls() {
        return this.idleMillisBetweenCalls;
    }
}

