/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingReporter {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingReporter.class);
    private final int maxConsecutiveWarnThrottles;
    private final String shardId;
    private int consecutiveThrottles = 0;

    public void throttled() {
        ++this.consecutiveThrottles;
        String message = "Shard '" + this.shardId + "' has been throttled " + this.consecutiveThrottles + " consecutively";
        if (this.consecutiveThrottles > this.maxConsecutiveWarnThrottles) {
            this.getLog().error(message);
        } else {
            this.getLog().warn(message);
        }
    }

    public void success() {
        this.consecutiveThrottles = 0;
    }

    protected Logger getLog() {
        return log;
    }

    public ThrottlingReporter(int maxConsecutiveWarnThrottles, String shardId) {
        this.maxConsecutiveWarnThrottles = maxConsecutiveWarnThrottles;
        this.shardId = shardId;
    }
}

