/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.kinesis.metrics.CloudWatchMetricKey;
import software.amazon.kinesis.metrics.MetricDatumWithKey;

public class CloudWatchMetricsPublisher {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchMetricsPublisher.class);
    private static final int BATCH_SIZE = 20;
    private final String namespace;
    private final CloudWatchAsyncClient cloudWatchClient;

    public CloudWatchMetricsPublisher(CloudWatchAsyncClient cloudWatchClient, String namespace) {
        this.cloudWatchClient = cloudWatchClient;
        this.namespace = namespace;
    }

    public void publishMetrics(List<MetricDatumWithKey<CloudWatchMetricKey>> dataToPublish) {
        for (int startIndex = 0; startIndex < dataToPublish.size(); startIndex += 20) {
            int endIndex = Math.min(dataToPublish.size(), startIndex + 20);
            PutMetricDataRequest.Builder request = PutMetricDataRequest.builder();
            request = request.namespace(this.namespace);
            ArrayList<MetricDatum> metricData = new ArrayList<MetricDatum>();
            for (int i = startIndex; i < endIndex; ++i) {
                metricData.add(dataToPublish.get((int)i).datum);
            }
            request = request.metricData(metricData);
            try {
                this.cloudWatchClient.putMetricData((PutMetricDataRequest)request.build());
                log.debug("Successfully published {} datums.", (Object)(endIndex - startIndex));
                continue;
            }
            catch (CloudWatchException e) {
                log.warn("Could not publish {} datums to CloudWatch", (Object)(endIndex - startIndex), (Object)e);
            }
        }
    }
}

