/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import software.amazon.kinesis.lifecycle.ConsumerState;
import software.amazon.kinesis.lifecycle.ConsumerStates;

public enum ShutdownReason {
    LEASE_LOST(3, ConsumerStates.ShardConsumerState.SHUTTING_DOWN.consumerState()),
    SHARD_END(2, ConsumerStates.ShardConsumerState.SHUTTING_DOWN.consumerState()),
    REQUESTED(1, ConsumerStates.ShardConsumerState.SHUTDOWN_REQUESTED.consumerState());

    private final int rank;
    private final ConsumerState shutdownState;

    private ShutdownReason(int rank, ConsumerState shutdownState) {
        this.rank = rank;
        this.shutdownState = shutdownState;
    }

    public boolean canTransitionTo(ShutdownReason reason) {
        if (reason == null) {
            return false;
        }
        return reason.rank > this.rank;
    }

    ConsumerState shutdownState() {
        return this.shutdownState;
    }
}

