/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.ShutdownNotification;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.lifecycle.events.ShutdownRequestedInput;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.processor.ShardRecordProcessor;

@KinesisClientInternalApi
public class ShutdownNotificationTask
implements ConsumerTask {
    private static final Logger log = LoggerFactory.getLogger(ShutdownNotificationTask.class);
    private final ShardRecordProcessor shardRecordProcessor;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ShutdownNotification shutdownNotification;
    private final ShardInfo shardInfo;

    @Override
    public TaskResult call() {
        try {
            try {
                this.shardRecordProcessor.shutdownRequested(ShutdownRequestedInput.builder().checkpointer(this.recordProcessorCheckpointer).build());
            }
            catch (Exception ex) {
                TaskResult taskResult = new TaskResult(ex);
                this.shutdownNotification.shutdownNotificationComplete();
                return taskResult;
            }
            TaskResult taskResult = new TaskResult(null);
            return taskResult;
        }
        finally {
            this.shutdownNotification.shutdownNotificationComplete();
        }
    }

    @Override
    public TaskType taskType() {
        return TaskType.SHUTDOWN_NOTIFICATION;
    }

    ShutdownNotificationTask(ShardRecordProcessor shardRecordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, ShutdownNotification shutdownNotification, ShardInfo shardInfo) {
        this.shardRecordProcessor = shardRecordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.shutdownNotification = shutdownNotification;
        this.shardInfo = shardInfo;
    }
}

