/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config.converter;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.Tag;

public class TagConverter
implements Converter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagConverter.class);

    public <T> T convert(Class<T> type, Object value) {
        String[] keyValuePairs;
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(TagCollection.class)) {
            throw new ConversionException("Can only convert to Collection<Tag>");
        }
        TagCollection collection = new TagCollection();
        String tagString = value.toString().trim();
        for (String keyValuePair : keyValuePairs = tagString.split(",")) {
            String[] tokens = keyValuePair.trim().split("=");
            if (tokens.length != 2) {
                log.warn("Invalid tag {}, ignoring it", (Object)keyValuePair);
                continue;
            }
            Tag tag = (Tag)Tag.builder().key(tokens[0].trim()).value(tokens[1].trim()).build();
            log.info("Created tag {}", (Object)tag);
            collection.add(tag);
        }
        return type.cast(collection);
    }

    public static class TagCollection
    extends ArrayList<Tag> {
    }

    public static class ConversionException
    extends RuntimeException {
        public ConversionException(String message) {
            super(message);
        }
    }
}

