/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config.converter;

import java.time.Duration;
import org.apache.commons.beanutils.Converter;

public class DurationConverter
implements Converter {
    public <T> T convert(Class<T> type, Object value) {
        if (value == null) {
            return null;
        }
        if (type != Duration.class) {
            throw new ConversionException("Can only convert to Duration");
        }
        String durationString = value.toString().trim();
        Duration duration = Duration.parse(durationString);
        if (duration.isNegative()) {
            throw new ConversionException("Negative values are not permitted for duration: " + durationString);
        }
        return type.cast(duration);
    }

    public static class ConversionException
    extends RuntimeException {
        public ConversionException(String message) {
            super(message);
        }
    }
}

