/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.KinesisClientUtil;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.ShardPrioritization;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.multilang.config.AwsCredentialsProviderPropertyValueDecoder;
import software.amazon.kinesis.multilang.config.BuilderDynaBean;
import software.amazon.kinesis.multilang.config.ConfigurationSettable;
import software.amazon.kinesis.multilang.config.ConfigurationSettableUtils;
import software.amazon.kinesis.multilang.config.ConfigurationSettables;
import software.amazon.kinesis.multilang.config.CoordinatorStateTableConfigBean;
import software.amazon.kinesis.multilang.config.FanoutConfigBean;
import software.amazon.kinesis.multilang.config.GracefulLeaseHandoffConfigBean;
import software.amazon.kinesis.multilang.config.PollingConfigBean;
import software.amazon.kinesis.multilang.config.RetrievalMode;
import software.amazon.kinesis.multilang.config.WorkerMetricStatsTableConfigBean;
import software.amazon.kinesis.multilang.config.WorkerUtilizationAwareAssignmentConfigBean;
import software.amazon.kinesis.multilang.config.converter.DurationConverter;
import software.amazon.kinesis.multilang.config.converter.TagConverter;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class MultiLangDaemonConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiLangDaemonConfiguration.class);
    private static final String CREDENTIALS_DEFAULT_SEARCH_PATH = "software.amazon.awssdk.auth.credentials";
    private String applicationName;
    private String streamName;
    private String streamArn;
    @ConfigurationSettable(configurationClass=ConfigsBuilder.class)
    private String tableName;
    private String workerIdentifier = UUID.randomUUID().toString();
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long failoverTimeMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long leaseAssignmentIntervalMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean enablePriorityLeaseAssignment;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean leaseTableDeletionProtectionEnabled;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean leaseTablePitrEnabled;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long shardSyncIntervalMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private boolean cleanupLeasesUponShardCompletion;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private boolean ignoreUnexpectedChildShards;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeasesForWorker;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeasesToStealAtOneTime;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int initialLeaseTableReadCapacity;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int initialLeaseTableWriteCapacity;
    @ConfigurationSettables(value={@ConfigurationSettable(configurationClass=LeaseManagementConfig.class, methodName="initialPositionInStream"), @ConfigurationSettable(configurationClass=RetrievalConfig.class)})
    private InitialPositionInStreamExtended initialPositionInStreamExtended;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeaseRenewalThreads;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long listShardsBackoffTimeInMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxListShardsRetryAttempts;
    @ConfigurationSettable(configurationClass=ProcessorConfig.class)
    private boolean callProcessRecordsEvenForEmptyRecordList;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private long parentShardPollIntervalMillis;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private ShardPrioritization shardPrioritization;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private long schedulerInitializationBackoffTimeMillis;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private CoordinatorConfig.ClientVersionConfig clientVersionConfig;
    @ConfigurationSettable(configurationClass=LifecycleConfig.class)
    private long taskBackoffTimeMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private long metricsBufferTimeMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private int metricsMaxQueueSize;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private MetricsLevel metricsLevel;
    @ConfigurationSettable(configurationClass=LifecycleConfig.class, convertToOptional=true)
    private Long logWarningForTaskAfterMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private Set<String> metricsEnabledDimensions;
    private RetrievalMode retrievalMode = RetrievalMode.DEFAULT;
    private final FanoutConfigBean fanoutConfig = new FanoutConfigBean();
    private final PollingConfigBean pollingConfig = new PollingConfigBean();
    private final GracefulLeaseHandoffConfigBean gracefulLeaseHandoffConfigBean = new GracefulLeaseHandoffConfigBean();
    private final WorkerUtilizationAwareAssignmentConfigBean workerUtilizationAwareAssignmentConfigBean = new WorkerUtilizationAwareAssignmentConfigBean();
    private final WorkerMetricStatsTableConfigBean workerMetricStatsTableConfigBean = new WorkerMetricStatsTableConfigBean();
    private final CoordinatorStateTableConfigBean coordinatorStateTableConfigBean = new CoordinatorStateTableConfigBean();
    private boolean validateSequenceNumberBeforeCheckpointing;
    private long shutdownGraceMillis;
    private Integer timeoutInSeconds;
    private final BuilderDynaBean kinesisCredentialsProvider;
    private final BuilderDynaBean dynamoDBCredentialsProvider;
    private final BuilderDynaBean cloudWatchCredentialsProvider;
    private final BuilderDynaBean kinesisClient;
    private final BuilderDynaBean dynamoDbClient;
    private final BuilderDynaBean cloudWatchClient;
    private final BeanUtilsBean utilsBean;
    private final ConvertUtilsBean convertUtilsBean;

    public void setWorkerId(String workerId) {
        this.workerIdentifier = workerId;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        if (this.initialPositionInStreamExtended != null) {
            return this.initialPositionInStreamExtended.getInitialPositionInStream();
        }
        return null;
    }

    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
    }

    public String[] getMetricsEnabledDimensions() {
        return this.metricsEnabledDimensions.toArray(new String[0]);
    }

    public void setMetricsEnabledDimensions(String[] dimensions) {
        this.metricsEnabledDimensions = new HashSet<String>(Arrays.asList(dimensions));
    }

    public void setAwsCredentialsProvider(String providerString) {
        this.kinesisCredentialsProvider.set("", providerString);
    }

    public void setAwsCredentialsProviderDynamoDB(String providerString) {
        this.dynamoDBCredentialsProvider.set("", providerString);
    }

    public void setAwsCredentialsProviderCloudWatch(String providerString) {
        this.cloudWatchCredentialsProvider.set("", providerString);
    }

    public MultiLangDaemonConfiguration(BeanUtilsBean utilsBean, ConvertUtilsBean convertUtilsBean) {
        this.utilsBean = utilsBean;
        this.convertUtilsBean = convertUtilsBean;
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                Date date = new Date(Long.parseLong(value.toString()) * 1000L);
                return type.cast(InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)date));
            }
        }, InitialPositionInStreamExtended.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(MetricsLevel.valueOf((String)value.toString().toUpperCase()));
            }
        }, MetricsLevel.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(InitialPositionInStream.valueOf((String)value.toString().toUpperCase()));
            }
        }, InitialPositionInStream.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(CoordinatorConfig.ClientVersionConfig.valueOf((String)value.toString().toUpperCase()));
            }
        }, CoordinatorConfig.ClientVersionConfig.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(BillingMode.valueOf((String)value.toString().toUpperCase()));
            }
        }, BillingMode.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(URI.create(value.toString()));
            }
        }, URI.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast((Object)RetrievalMode.from(value.toString()));
            }
        }, RetrievalMode.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(Region.of((String)value.toString()));
            }
        }, Region.class);
        convertUtilsBean.register((Converter)new DurationConverter(), Duration.class);
        convertUtilsBean.register((Converter)new TagConverter(), TagConverter.TagCollection.class);
        ArrayConverter arrayConverter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        arrayConverter.setDelimiter(',');
        convertUtilsBean.register((Converter)arrayConverter, String[].class);
        AwsCredentialsProviderPropertyValueDecoder credentialsDecoder = new AwsCredentialsProviderPropertyValueDecoder();
        Function<String, Object> converter = credentialsDecoder::decodeValue;
        this.kinesisCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.dynamoDBCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.cloudWatchCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.kinesisClient = new BuilderDynaBean(KinesisAsyncClient.class, convertUtilsBean, new String[0]);
        this.dynamoDbClient = new BuilderDynaBean(DynamoDbAsyncClient.class, convertUtilsBean, new String[0]);
        this.cloudWatchClient = new BuilderDynaBean(CloudWatchAsyncClient.class, convertUtilsBean, new String[0]);
    }

    private void setRegionForClient(String name, BuilderDynaBean client, Region region) {
        try {
            this.utilsBean.setProperty((Object)client, "region", (Object)region);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to set region on {}", (Object)name, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public void setRegionName(Region region) {
        this.setRegionForClient("kinesisClient", this.kinesisClient, region);
        this.setRegionForClient("dynamoDbClient", this.dynamoDbClient, region);
        this.setRegionForClient("cloudWatchClient", this.cloudWatchClient, region);
    }

    private void setEndpointForClient(String name, BuilderDynaBean client, String endpoint) {
        try {
            this.utilsBean.setProperty((Object)client, "endpointOverride", (Object)endpoint);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to set endpoint on {}", (Object)name, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public void setKinesisEndpoint(String endpoint) {
        this.setEndpointForClient("kinesisClient", this.kinesisClient, endpoint);
    }

    public void setDynamoDBEndpoint(String endpoint) {
        this.setEndpointForClient("dynamoDbClient", this.dynamoDbClient, endpoint);
    }

    private AwsCredentialsProvider resolveCredentials(BuilderDynaBean credsBuilder) {
        if (!credsBuilder.isDirty()) {
            return null;
        }
        return credsBuilder.build(AwsCredentialsProvider.class, new Function[0]);
    }

    private void updateCredentials(BuilderDynaBean toUpdate, AwsCredentialsProvider primary, AwsCredentialsProvider secondary) {
        if (toUpdate.hasValue("credentialsProvider")) {
            return;
        }
        try {
            if (primary != null) {
                this.utilsBean.setProperty((Object)toUpdate, "credentialsProvider", (Object)primary);
            } else if (secondary != null) {
                this.utilsBean.setProperty((Object)toUpdate, "credentialsProvider", (Object)secondary);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unable to update credentials", e);
        }
    }

    private void addConfigObjects(Map<Class<?>, Object> configObjects, Object ... toAdd) {
        for (Object obj : toAdd) {
            configObjects.put(obj.getClass(), obj);
        }
    }

    private void resolveFields(Map<Class<?>, Object> configObjects, Set<Class<?>> restrictTo, Set<Class<?>> skipIf) {
        ConfigurationSettableUtils.resolveFields(this, configObjects, restrictTo, skipIf);
    }

    private void handleRetrievalConfig(RetrievalConfig retrievalConfig, ConfigsBuilder configsBuilder) {
        retrievalConfig.retrievalSpecificConfig(this.retrievalMode.builder(this).build(configsBuilder.kinesisClient(), this));
    }

    private void handleCoordinatorConfig(CoordinatorConfig coordinatorConfig) {
        ConfigurationSettableUtils.resolveFields(this.coordinatorStateTableConfigBean, coordinatorConfig.coordinatorStateTableConfig());
    }

    private void handleLeaseManagementConfig(LeaseManagementConfig leaseManagementConfig) {
        ConfigurationSettableUtils.resolveFields(this.gracefulLeaseHandoffConfigBean, leaseManagementConfig.gracefulLeaseHandoffConfig());
        ConfigurationSettableUtils.resolveFields(this.workerUtilizationAwareAssignmentConfigBean, leaseManagementConfig.workerUtilizationAwareAssignmentConfig());
        ConfigurationSettableUtils.resolveFields(this.workerMetricStatsTableConfigBean, leaseManagementConfig.workerUtilizationAwareAssignmentConfig().workerMetricsTableConfig());
    }

    private Object adjustKinesisHttpConfiguration(Object builderObj) {
        if (builderObj instanceof KinesisAsyncClientBuilder) {
            KinesisAsyncClientBuilder builder = (KinesisAsyncClientBuilder)builderObj;
            return builder.applyMutation(KinesisClientUtil::adjustKinesisClientBuilder);
        }
        return builderObj;
    }

    ResolvedConfiguration resolvedConfiguration(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        AwsCredentialsProvider kinesisCreds = this.resolveCredentials(this.kinesisCredentialsProvider);
        AwsCredentialsProvider dynamoDbCreds = this.resolveCredentials(this.dynamoDBCredentialsProvider);
        AwsCredentialsProvider cloudwatchCreds = this.resolveCredentials(this.cloudWatchCredentialsProvider);
        this.updateCredentials(this.kinesisClient, kinesisCreds, kinesisCreds);
        this.updateCredentials(this.dynamoDbClient, dynamoDbCreds, kinesisCreds);
        this.updateCredentials(this.cloudWatchClient, cloudwatchCreds, kinesisCreds);
        KinesisAsyncClient kinesisAsyncClient = this.kinesisClient.build(KinesisAsyncClient.class, this::adjustKinesisHttpConfiguration);
        DynamoDbAsyncClient dynamoDbAsyncClient = this.dynamoDbClient.build(DynamoDbAsyncClient.class, new Function[0]);
        CloudWatchAsyncClient cloudWatchAsyncClient = this.cloudWatchClient.build(CloudWatchAsyncClient.class, new Function[0]);
        ConfigsBuilder configsBuilder = new ConfigsBuilder(this.streamName, this.applicationName, kinesisAsyncClient, dynamoDbAsyncClient, cloudWatchAsyncClient, this.workerIdentifier, shardRecordProcessorFactory);
        HashMap configObjects = new HashMap();
        this.addConfigObjects(configObjects, configsBuilder);
        this.resolveFields(configObjects, Collections.singleton(ConfigsBuilder.class), Collections.singleton(PollingConfig.class));
        CoordinatorConfig coordinatorConfig = configsBuilder.coordinatorConfig();
        CheckpointConfig checkpointConfig = configsBuilder.checkpointConfig();
        LeaseManagementConfig leaseManagementConfig = configsBuilder.leaseManagementConfig();
        LifecycleConfig lifecycleConfig = configsBuilder.lifecycleConfig();
        MetricsConfig metricsConfig = configsBuilder.metricsConfig();
        ProcessorConfig processorConfig = configsBuilder.processorConfig();
        RetrievalConfig retrievalConfig = configsBuilder.retrievalConfig();
        this.addConfigObjects(configObjects, coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
        this.handleCoordinatorConfig(coordinatorConfig);
        this.handleLeaseManagementConfig(leaseManagementConfig);
        this.handleRetrievalConfig(retrievalConfig, configsBuilder);
        this.resolveFields(configObjects, null, new HashSet(Arrays.asList(ConfigsBuilder.class, PollingConfig.class)));
        return new ResolvedConfiguration(coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
    }

    public Scheduler build(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        return this.resolvedConfiguration(shardRecordProcessorFactory).build();
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public String getStreamName() {
        return this.streamName;
    }

    @Generated
    public String getStreamArn() {
        return this.streamArn;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    @Generated
    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    @Generated
    public long getLeaseAssignmentIntervalMillis() {
        return this.leaseAssignmentIntervalMillis;
    }

    @Generated
    public Boolean getEnablePriorityLeaseAssignment() {
        return this.enablePriorityLeaseAssignment;
    }

    @Generated
    public Boolean getLeaseTableDeletionProtectionEnabled() {
        return this.leaseTableDeletionProtectionEnabled;
    }

    @Generated
    public Boolean getLeaseTablePitrEnabled() {
        return this.leaseTablePitrEnabled;
    }

    @Generated
    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    @Generated
    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    @Generated
    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    @Generated
    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    @Generated
    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    @Generated
    public int getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    @Generated
    public int getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    @Generated
    public InitialPositionInStreamExtended getInitialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    @Generated
    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    @Generated
    public long getListShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    @Generated
    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    @Generated
    public boolean isCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    @Generated
    public long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    @Generated
    public ShardPrioritization getShardPrioritization() {
        return this.shardPrioritization;
    }

    @Generated
    public boolean isSkipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    @Generated
    public long getSchedulerInitializationBackoffTimeMillis() {
        return this.schedulerInitializationBackoffTimeMillis;
    }

    @Generated
    public CoordinatorConfig.ClientVersionConfig getClientVersionConfig() {
        return this.clientVersionConfig;
    }

    @Generated
    public long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    @Generated
    public long getMetricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    @Generated
    public int getMetricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    @Generated
    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    @Generated
    public Long getLogWarningForTaskAfterMillis() {
        return this.logWarningForTaskAfterMillis;
    }

    @Generated
    public RetrievalMode getRetrievalMode() {
        return this.retrievalMode;
    }

    @Generated
    public FanoutConfigBean getFanoutConfig() {
        return this.fanoutConfig;
    }

    @Generated
    public PollingConfigBean getPollingConfig() {
        return this.pollingConfig;
    }

    @Generated
    public GracefulLeaseHandoffConfigBean getGracefulLeaseHandoffConfigBean() {
        return this.gracefulLeaseHandoffConfigBean;
    }

    @Generated
    public WorkerUtilizationAwareAssignmentConfigBean getWorkerUtilizationAwareAssignmentConfigBean() {
        return this.workerUtilizationAwareAssignmentConfigBean;
    }

    @Generated
    public WorkerMetricStatsTableConfigBean getWorkerMetricStatsTableConfigBean() {
        return this.workerMetricStatsTableConfigBean;
    }

    @Generated
    public CoordinatorStateTableConfigBean getCoordinatorStateTableConfigBean() {
        return this.coordinatorStateTableConfigBean;
    }

    @Generated
    public boolean isValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }

    @Generated
    public long getShutdownGraceMillis() {
        return this.shutdownGraceMillis;
    }

    @Generated
    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @Generated
    public BuilderDynaBean getKinesisCredentialsProvider() {
        return this.kinesisCredentialsProvider;
    }

    @Generated
    public BuilderDynaBean getDynamoDBCredentialsProvider() {
        return this.dynamoDBCredentialsProvider;
    }

    @Generated
    public BuilderDynaBean getCloudWatchCredentialsProvider() {
        return this.cloudWatchCredentialsProvider;
    }

    @Generated
    public BuilderDynaBean getKinesisClient() {
        return this.kinesisClient;
    }

    @Generated
    public BuilderDynaBean getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Generated
    public BuilderDynaBean getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    @Generated
    public BeanUtilsBean getUtilsBean() {
        return this.utilsBean;
    }

    @Generated
    public ConvertUtilsBean getConvertUtilsBean() {
        return this.convertUtilsBean;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    @Generated
    public void setStreamArn(String streamArn) {
        this.streamArn = streamArn;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setWorkerIdentifier(String workerIdentifier) {
        this.workerIdentifier = workerIdentifier;
    }

    @Generated
    public void setFailoverTimeMillis(long failoverTimeMillis) {
        this.failoverTimeMillis = failoverTimeMillis;
    }

    @Generated
    public void setLeaseAssignmentIntervalMillis(long leaseAssignmentIntervalMillis) {
        this.leaseAssignmentIntervalMillis = leaseAssignmentIntervalMillis;
    }

    @Generated
    public void setEnablePriorityLeaseAssignment(Boolean enablePriorityLeaseAssignment) {
        this.enablePriorityLeaseAssignment = enablePriorityLeaseAssignment;
    }

    @Generated
    public void setLeaseTableDeletionProtectionEnabled(Boolean leaseTableDeletionProtectionEnabled) {
        this.leaseTableDeletionProtectionEnabled = leaseTableDeletionProtectionEnabled;
    }

    @Generated
    public void setLeaseTablePitrEnabled(Boolean leaseTablePitrEnabled) {
        this.leaseTablePitrEnabled = leaseTablePitrEnabled;
    }

    @Generated
    public void setShardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
    }

    @Generated
    public void setCleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
    }

    @Generated
    public void setIgnoreUnexpectedChildShards(boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
    }

    @Generated
    public void setMaxLeasesForWorker(int maxLeasesForWorker) {
        this.maxLeasesForWorker = maxLeasesForWorker;
    }

    @Generated
    public void setMaxLeasesToStealAtOneTime(int maxLeasesToStealAtOneTime) {
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
    }

    @Generated
    public void setInitialLeaseTableReadCapacity(int initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
    }

    @Generated
    public void setInitialLeaseTableWriteCapacity(int initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
    }

    @Generated
    public void setInitialPositionInStreamExtended(InitialPositionInStreamExtended initialPositionInStreamExtended) {
        this.initialPositionInStreamExtended = initialPositionInStreamExtended;
    }

    @Generated
    public void setMaxLeaseRenewalThreads(int maxLeaseRenewalThreads) {
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
    }

    @Generated
    public void setListShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
    }

    @Generated
    public void setMaxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
    }

    @Generated
    public void setCallProcessRecordsEvenForEmptyRecordList(boolean callProcessRecordsEvenForEmptyRecordList) {
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
    }

    @Generated
    public void setParentShardPollIntervalMillis(long parentShardPollIntervalMillis) {
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }

    @Generated
    public void setShardPrioritization(ShardPrioritization shardPrioritization) {
        this.shardPrioritization = shardPrioritization;
    }

    @Generated
    public void setSkipShardSyncAtWorkerInitializationIfLeasesExist(boolean skipShardSyncAtWorkerInitializationIfLeasesExist) {
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    @Generated
    public void setSchedulerInitializationBackoffTimeMillis(long schedulerInitializationBackoffTimeMillis) {
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
    }

    @Generated
    public void setClientVersionConfig(CoordinatorConfig.ClientVersionConfig clientVersionConfig) {
        this.clientVersionConfig = clientVersionConfig;
    }

    @Generated
    public void setTaskBackoffTimeMillis(long taskBackoffTimeMillis) {
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
    }

    @Generated
    public void setMetricsBufferTimeMillis(long metricsBufferTimeMillis) {
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
    }

    @Generated
    public void setMetricsMaxQueueSize(int metricsMaxQueueSize) {
        this.metricsMaxQueueSize = metricsMaxQueueSize;
    }

    @Generated
    public void setMetricsLevel(MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel;
    }

    @Generated
    public void setLogWarningForTaskAfterMillis(Long logWarningForTaskAfterMillis) {
        this.logWarningForTaskAfterMillis = logWarningForTaskAfterMillis;
    }

    @Generated
    public void setRetrievalMode(RetrievalMode retrievalMode) {
        this.retrievalMode = retrievalMode;
    }

    @Generated
    public void setValidateSequenceNumberBeforeCheckpointing(boolean validateSequenceNumberBeforeCheckpointing) {
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
    }

    @Generated
    public void setShutdownGraceMillis(long shutdownGraceMillis) {
        this.shutdownGraceMillis = shutdownGraceMillis;
    }

    @Generated
    public void setTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Generated
    public Integer getRetryGetRecordsInSeconds() {
        return this.getPollingConfig().getRetryGetRecordsInSeconds();
    }

    @Generated
    public void setRetryGetRecordsInSeconds(Integer value) {
        this.getPollingConfig().setRetryGetRecordsInSeconds(value);
    }

    @Generated
    public Integer getMaxGetRecordsThreadPool() {
        return this.getPollingConfig().getMaxGetRecordsThreadPool();
    }

    @Generated
    public void setMaxGetRecordsThreadPool(Integer value) {
        this.getPollingConfig().setMaxGetRecordsThreadPool(value);
    }

    @Generated
    public long getIdleTimeBetweenReadsInMillis() {
        return this.getPollingConfig().getIdleTimeBetweenReadsInMillis();
    }

    @Generated
    public void setIdleTimeBetweenReadsInMillis(long value) {
        this.getPollingConfig().setIdleTimeBetweenReadsInMillis(value);
    }

    @Generated
    public long getMillisBehindLatestThresholdForReducedTps() {
        return this.getPollingConfig().getMillisBehindLatestThresholdForReducedTps();
    }

    @Generated
    public void setMillisBehindLatestThresholdForReducedTps(long value) {
        this.getPollingConfig().setMillisBehindLatestThresholdForReducedTps(value);
    }

    @Generated
    public int getMaxRecords() {
        return this.getPollingConfig().getMaxRecords();
    }

    @Generated
    public void setMaxRecords(int value) {
        this.getPollingConfig().setMaxRecords(value);
    }

    @Generated
    public Long getGracefulLeaseHandoffTimeoutMillis() {
        return this.getGracefulLeaseHandoffConfigBean().getGracefulLeaseHandoffTimeoutMillis();
    }

    @Generated
    public void setGracefulLeaseHandoffTimeoutMillis(Long value) {
        this.getGracefulLeaseHandoffConfigBean().setGracefulLeaseHandoffTimeoutMillis(value);
    }

    @Generated
    public Boolean getIsGracefulLeaseHandoffEnabled() {
        return this.getGracefulLeaseHandoffConfigBean().getIsGracefulLeaseHandoffEnabled();
    }

    @Generated
    public void setIsGracefulLeaseHandoffEnabled(Boolean value) {
        this.getGracefulLeaseHandoffConfigBean().setIsGracefulLeaseHandoffEnabled(value);
    }

    @Generated
    public long getInMemoryWorkerMetricsCaptureFrequencyMillis() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getInMemoryWorkerMetricsCaptureFrequencyMillis();
    }

    @Generated
    public void setInMemoryWorkerMetricsCaptureFrequencyMillis(long value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setInMemoryWorkerMetricsCaptureFrequencyMillis(value);
    }

    @Generated
    public long getWorkerMetricsReporterFreqInMillis() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getWorkerMetricsReporterFreqInMillis();
    }

    @Generated
    public void setWorkerMetricsReporterFreqInMillis(long value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setWorkerMetricsReporterFreqInMillis(value);
    }

    @Generated
    public int getNoOfPersistedMetricsPerWorkerMetrics() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getNoOfPersistedMetricsPerWorkerMetrics();
    }

    @Generated
    public void setNoOfPersistedMetricsPerWorkerMetrics(int value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setNoOfPersistedMetricsPerWorkerMetrics(value);
    }

    @Generated
    public Boolean getDisableWorkerMetrics() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getDisableWorkerMetrics();
    }

    @Generated
    public void setDisableWorkerMetrics(Boolean value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setDisableWorkerMetrics(value);
    }

    @Generated
    public double getMaxThroughputPerHostKBps() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getMaxThroughputPerHostKBps();
    }

    @Generated
    public void setMaxThroughputPerHostKBps(double value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setMaxThroughputPerHostKBps(value);
    }

    @Generated
    public int getDampeningPercentage() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getDampeningPercentage();
    }

    @Generated
    public void setDampeningPercentage(int value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setDampeningPercentage(value);
    }

    @Generated
    public int getReBalanceThresholdPercentage() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getReBalanceThresholdPercentage();
    }

    @Generated
    public void setReBalanceThresholdPercentage(int value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setReBalanceThresholdPercentage(value);
    }

    @Generated
    public Boolean getAllowThroughputOvershoot() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getAllowThroughputOvershoot();
    }

    @Generated
    public void setAllowThroughputOvershoot(Boolean value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setAllowThroughputOvershoot(value);
    }

    @Generated
    public int getVarianceBalancingFrequency() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getVarianceBalancingFrequency();
    }

    @Generated
    public void setVarianceBalancingFrequency(int value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setVarianceBalancingFrequency(value);
    }

    @Generated
    public double getWorkerMetricsEMAAlpha() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getWorkerMetricsEMAAlpha();
    }

    @Generated
    public void setWorkerMetricsEMAAlpha(double value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setWorkerMetricsEMAAlpha(value);
    }

    @Generated
    public void setStaleWorkerMetricsEntryCleanupDuration(Duration value) {
        this.getWorkerUtilizationAwareAssignmentConfigBean().setStaleWorkerMetricsEntryCleanupDuration(value);
    }

    @Generated
    public Duration getStaleWorkerMetricsEntryCleanupDuration() {
        return this.getWorkerUtilizationAwareAssignmentConfigBean().getStaleWorkerMetricsEntryCleanupDuration();
    }

    @Generated
    public String getWorkerMetricsTableName() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsTableName();
    }

    @Generated
    public void setWorkerMetricsTableName(String value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsTableName(value);
    }

    @Generated
    public BillingMode getWorkerMetricsBillingMode() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsBillingMode();
    }

    @Generated
    public void setWorkerMetricsBillingMode(BillingMode value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsBillingMode(value);
    }

    @Generated
    public long getWorkerMetricsReadCapacity() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsReadCapacity();
    }

    @Generated
    public void setWorkerMetricsReadCapacity(long value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsReadCapacity(value);
    }

    @Generated
    public long getWorkerMetricsWriteCapacity() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsWriteCapacity();
    }

    @Generated
    public void setWorkerMetricsWriteCapacity(long value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsWriteCapacity(value);
    }

    @Generated
    public Boolean getWorkerMetricsPointInTimeRecoveryEnabled() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsPointInTimeRecoveryEnabled();
    }

    @Generated
    public void setWorkerMetricsPointInTimeRecoveryEnabled(Boolean value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsPointInTimeRecoveryEnabled(value);
    }

    @Generated
    public Boolean getWorkerMetricsDeletionProtectionEnabled() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsDeletionProtectionEnabled();
    }

    @Generated
    public void setWorkerMetricsDeletionProtectionEnabled(Boolean value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsDeletionProtectionEnabled(value);
    }

    @Generated
    public TagConverter.TagCollection getWorkerMetricsTags() {
        return this.getWorkerMetricStatsTableConfigBean().getWorkerMetricsTags();
    }

    @Generated
    public void setWorkerMetricsTags(TagConverter.TagCollection value) {
        this.getWorkerMetricStatsTableConfigBean().setWorkerMetricsTags(value);
    }

    @Generated
    public String getCoordinatorStateTableName() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateTableName();
    }

    @Generated
    public void setCoordinatorStateTableName(String value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateTableName(value);
    }

    @Generated
    public BillingMode getCoordinatorStateBillingMode() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateBillingMode();
    }

    @Generated
    public void setCoordinatorStateBillingMode(BillingMode value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateBillingMode(value);
    }

    @Generated
    public long getCoordinatorStateReadCapacity() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateReadCapacity();
    }

    @Generated
    public void setCoordinatorStateReadCapacity(long value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateReadCapacity(value);
    }

    @Generated
    public long getCoordinatorStateWriteCapacity() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateWriteCapacity();
    }

    @Generated
    public void setCoordinatorStateWriteCapacity(long value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateWriteCapacity(value);
    }

    @Generated
    public Boolean getCoordinatorStatePointInTimeRecoveryEnabled() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStatePointInTimeRecoveryEnabled();
    }

    @Generated
    public void setCoordinatorStatePointInTimeRecoveryEnabled(Boolean value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStatePointInTimeRecoveryEnabled(value);
    }

    @Generated
    public Boolean getCoordinatorStateDeletionProtectionEnabled() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateDeletionProtectionEnabled();
    }

    @Generated
    public void setCoordinatorStateDeletionProtectionEnabled(Boolean value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateDeletionProtectionEnabled(value);
    }

    @Generated
    public TagConverter.TagCollection getCoordinatorStateTags() {
        return this.getCoordinatorStateTableConfigBean().getCoordinatorStateTags();
    }

    @Generated
    public void setCoordinatorStateTags(TagConverter.TagCollection value) {
        this.getCoordinatorStateTableConfigBean().setCoordinatorStateTags(value);
    }

    static class ResolvedConfiguration {
        final CoordinatorConfig coordinatorConfig;
        final CheckpointConfig checkpointConfig;
        final LeaseManagementConfig leaseManagementConfig;
        final LifecycleConfig lifecycleConfig;
        final MetricsConfig metricsConfig;
        final ProcessorConfig processorConfig;
        final RetrievalConfig retrievalConfig;

        public Scheduler build() {
            return new Scheduler(this.checkpointConfig, this.coordinatorConfig, this.leaseManagementConfig, this.lifecycleConfig, this.metricsConfig, this.processorConfig, this.retrievalConfig);
        }

        @Generated
        public ResolvedConfiguration(CoordinatorConfig coordinatorConfig, CheckpointConfig checkpointConfig, LeaseManagementConfig leaseManagementConfig, LifecycleConfig lifecycleConfig, MetricsConfig metricsConfig, ProcessorConfig processorConfig, RetrievalConfig retrievalConfig) {
            this.coordinatorConfig = coordinatorConfig;
            this.checkpointConfig = checkpointConfig;
            this.leaseManagementConfig = leaseManagementConfig;
            this.lifecycleConfig = lifecycleConfig;
            this.metricsConfig = metricsConfig;
            this.processorConfig = processorConfig;
            this.retrievalConfig = retrievalConfig;
        }

        @Generated
        public CoordinatorConfig getCoordinatorConfig() {
            return this.coordinatorConfig;
        }

        @Generated
        public CheckpointConfig getCheckpointConfig() {
            return this.checkpointConfig;
        }

        @Generated
        public LeaseManagementConfig getLeaseManagementConfig() {
            return this.leaseManagementConfig;
        }

        @Generated
        public LifecycleConfig getLifecycleConfig() {
            return this.lifecycleConfig;
        }

        @Generated
        public MetricsConfig getMetricsConfig() {
            return this.metricsConfig;
        }

        @Generated
        public ProcessorConfig getProcessorConfig() {
            return this.processorConfig;
        }

        @Generated
        public RetrievalConfig getRetrievalConfig() {
            return this.retrievalConfig;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedConfiguration)) {
                return false;
            }
            ResolvedConfiguration other = (ResolvedConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CoordinatorConfig this$coordinatorConfig = this.getCoordinatorConfig();
            CoordinatorConfig other$coordinatorConfig = other.getCoordinatorConfig();
            if (this$coordinatorConfig == null ? other$coordinatorConfig != null : !this$coordinatorConfig.equals(other$coordinatorConfig)) {
                return false;
            }
            CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
            CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
            if (this$checkpointConfig == null ? other$checkpointConfig != null : !this$checkpointConfig.equals(other$checkpointConfig)) {
                return false;
            }
            LeaseManagementConfig this$leaseManagementConfig = this.getLeaseManagementConfig();
            LeaseManagementConfig other$leaseManagementConfig = other.getLeaseManagementConfig();
            if (this$leaseManagementConfig == null ? other$leaseManagementConfig != null : !this$leaseManagementConfig.equals(other$leaseManagementConfig)) {
                return false;
            }
            LifecycleConfig this$lifecycleConfig = this.getLifecycleConfig();
            LifecycleConfig other$lifecycleConfig = other.getLifecycleConfig();
            if (this$lifecycleConfig == null ? other$lifecycleConfig != null : !this$lifecycleConfig.equals(other$lifecycleConfig)) {
                return false;
            }
            MetricsConfig this$metricsConfig = this.getMetricsConfig();
            MetricsConfig other$metricsConfig = other.getMetricsConfig();
            if (this$metricsConfig == null ? other$metricsConfig != null : !this$metricsConfig.equals(other$metricsConfig)) {
                return false;
            }
            ProcessorConfig this$processorConfig = this.getProcessorConfig();
            ProcessorConfig other$processorConfig = other.getProcessorConfig();
            if (this$processorConfig == null ? other$processorConfig != null : !this$processorConfig.equals(other$processorConfig)) {
                return false;
            }
            RetrievalConfig this$retrievalConfig = this.getRetrievalConfig();
            RetrievalConfig other$retrievalConfig = other.getRetrievalConfig();
            return !(this$retrievalConfig == null ? other$retrievalConfig != null : !this$retrievalConfig.equals(other$retrievalConfig));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResolvedConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CoordinatorConfig $coordinatorConfig = this.getCoordinatorConfig();
            result = result * 59 + ($coordinatorConfig == null ? 43 : $coordinatorConfig.hashCode());
            CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
            result = result * 59 + ($checkpointConfig == null ? 43 : $checkpointConfig.hashCode());
            LeaseManagementConfig $leaseManagementConfig = this.getLeaseManagementConfig();
            result = result * 59 + ($leaseManagementConfig == null ? 43 : $leaseManagementConfig.hashCode());
            LifecycleConfig $lifecycleConfig = this.getLifecycleConfig();
            result = result * 59 + ($lifecycleConfig == null ? 43 : $lifecycleConfig.hashCode());
            MetricsConfig $metricsConfig = this.getMetricsConfig();
            result = result * 59 + ($metricsConfig == null ? 43 : $metricsConfig.hashCode());
            ProcessorConfig $processorConfig = this.getProcessorConfig();
            result = result * 59 + ($processorConfig == null ? 43 : $processorConfig.hashCode());
            RetrievalConfig $retrievalConfig = this.getRetrievalConfig();
            result = result * 59 + ($retrievalConfig == null ? 43 : $retrievalConfig.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiLangDaemonConfiguration.ResolvedConfiguration(coordinatorConfig=" + this.getCoordinatorConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", leaseManagementConfig=" + this.getLeaseManagementConfig() + ", lifecycleConfig=" + this.getLifecycleConfig() + ", metricsConfig=" + this.getMetricsConfig() + ", processorConfig=" + this.getProcessorConfig() + ", retrievalConfig=" + this.getRetrievalConfig() + ")";
        }
    }
}

