/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.ClassUtils;
import software.amazon.kinesis.multilang.config.BuilderDynaBean;
import software.amazon.kinesis.multilang.config.DynaBeanBuilderUtils;
import software.amazon.kinesis.multilang.config.TypeTag;

class DynaBeanBuilderSupport {
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_METHOD_NAME = "builder";
    private final Class<?> destinedClass;
    private final ConvertUtilsBean convertUtilsBean;
    private final List<String> classPrefixSearchList;
    private final Class<?> builderClass;
    private final Multimap<String, TypeTag> properties = HashMultimap.create();
    private final Map<String, Object> values = new HashMap<String, Object>();

    DynaBeanBuilderSupport(Class<?> destinedClass, ConvertUtilsBean convertUtilsBean, List<String> classPrefixSearchList) {
        this.destinedClass = destinedClass;
        this.convertUtilsBean = convertUtilsBean;
        this.classPrefixSearchList = classPrefixSearchList;
        this.builderClass = DynaBeanBuilderSupport.builderClassFrom(destinedClass);
        this.buildProperties();
    }

    private static Class<?> builderClassFrom(Class<?> destinedClass) {
        Method builderMethod;
        try {
            builderMethod = destinedClass.getMethod(BUILDER_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return builderMethod.getReturnType();
    }

    private void buildProperties() {
        if (this.builderClass == null) {
            return;
        }
        try {
            this.builderClass.getMethod(BUILD_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        for (Method method : this.builderClass.getMethods()) {
            Class<?> paramType;
            if (method.getParameterCount() != 1 || !ClassUtils.isAssignable(this.builderClass, method.getReturnType()) || Supplier.class.isAssignableFrom(paramType = method.getParameterTypes()[0]) || Consumer.class.isAssignableFrom(paramType)) continue;
            if (paramType.isEnum()) {
                this.properties.put((Object)method.getName(), (Object)new TypeTag(paramType, true, method));
                continue;
            }
            if (this.convertUtilsBean.lookup(paramType) == null) {
                this.properties.put((Object)method.getName(), (Object)new TypeTag(paramType, false, method));
                continue;
            }
            this.properties.put((Object)method.getName(), (Object)new TypeTag(paramType, true, method));
        }
    }

    boolean isValid() {
        return this.builderClass != null;
    }

    private Object createForProperty(String name) {
        Optional type = this.properties.get((Object)name).stream().findFirst();
        return type.map(t -> {
            if (DynaBeanBuilderUtils.isBuilderOrCreate(t.type) || !t.hasConverter) {
                return new BuilderDynaBean(t.type, this.convertUtilsBean, null, this.classPrefixSearchList);
            }
            return null;
        }).orElse(null);
    }

    boolean hasValue(String name) {
        return this.values.containsKey(name);
    }

    Object get(String name) {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        Object value = this.createForProperty(name);
        if (value != null) {
            this.values.put(name, value);
        }
        return this.values.get(name);
    }

    private Object[] retrieveAndResizeArray(String name, int index) {
        Object[] destination;
        Object existing = this.values.get(name);
        if (existing != null) {
            if (!existing.getClass().isArray()) {
                throw new IllegalStateException("Requested get for an array, but existing value isn't an array");
            }
            destination = (Object[])existing;
            if (index >= destination.length) {
                destination = Arrays.copyOf(destination, index + 1);
                this.values.put(name, destination);
            }
        } else {
            destination = new Object[index + 1];
            this.values.put(name, destination);
        }
        return destination;
    }

    Object get(String name, int index) {
        Object[] destination = this.retrieveAndResizeArray(name, index);
        if (destination[index] == null) {
            destination[index] = this.createForProperty(name);
        }
        return destination[index];
    }

    void set(String name, Object value) {
        if (value instanceof String && this.properties.get((Object)name).stream().anyMatch(t -> t.type.isEnum())) {
            TypeTag typeTag = this.properties.get((Object)name).stream().filter(t -> t.type.isEnum()).findFirst().orElseThrow(() -> new IllegalStateException("Expected enum type for " + name + ", but couldn't find it."));
            Class<?> enumClass = typeTag.type;
            this.values.put(name, Enum.valueOf(enumClass, value.toString()));
        } else {
            this.values.put(name, value);
        }
    }

    void set(String name, int index, Object value) {
        Object[] destination = this.retrieveAndResizeArray(name, index);
        destination[index] = value;
    }

    private Object getArgument(Map.Entry<String, Object> setValue) {
        Object argument = setValue.getValue();
        if (argument instanceof Object[]) {
            TypeTag arrayType = this.properties.get((Object)setValue.getKey()).stream().filter(t -> t.type.isArray()).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Received Object[] for %s but can't find corresponding type", setValue.getKey())));
            Object[] arrayValues = (Object[])argument;
            Object[] destination = (Object[])Array.newInstance(arrayType.type.getComponentType(), arrayValues.length);
            for (int i = 0; i < arrayValues.length; ++i) {
                destination[i] = arrayValues[i] instanceof BuilderDynaBean ? ((BuilderDynaBean)arrayValues[i]).build(Object.class, new Function[0]) : arrayValues[i];
            }
            return destination;
        }
        if (argument instanceof BuilderDynaBean) {
            argument = ((BuilderDynaBean)argument).build(Object.class, new Function[0]);
        }
        return argument;
    }

    Object build(Function<Object, Object> ... additionalMutators) {
        Object source;
        Method builderMethod;
        try {
            builderMethod = this.destinedClass.getMethod(BUILDER_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            source = builderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, Object> setValue : this.values.entrySet()) {
            Object argument = this.getArgument(setValue);
            Method method = this.properties.get((Object)setValue.getKey()).stream().filter(t -> ClassUtils.isAssignable(argument.getClass(), t.type)).findFirst().map(a -> a.builderMethod).orElseThrow(() -> new IllegalStateException(String.format("Unable to find mutator for %s of type %s", setValue.getKey(), argument.getClass().getName())));
            try {
                source = method.invoke(source, argument);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (additionalMutators != null) {
            for (Function<Object, Object> function : additionalMutators) {
                source = function.apply(source);
            }
        }
        try {
            Method buildMethod = this.builderClass.getMethod(BUILD_METHOD_NAME, new Class[0]);
            return buildMethod.invoke(source, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    List<TypeTag> getProperty(String name) {
        if (!this.properties.containsKey((Object)name)) {
            throw new IllegalArgumentException("Unknown property: " + name);
        }
        return new ArrayList<TypeTag>(this.properties.get((Object)name));
    }
}

