/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import com.google.common.base.Defaults;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import software.amazon.kinesis.multilang.config.ConfigurationSettable;

public class ConfigurationSettableUtils {
    public static <T> T resolveFields(@NonNull Object source, @NonNull T configObject) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (configObject == null) {
            throw new NullPointerException("configObject is marked non-null but is null");
        }
        HashMap configObjects = new HashMap();
        configObjects.put(configObject.getClass(), configObject);
        ConfigurationSettableUtils.resolveFields(source, configObjects, null, null);
        return configObject;
    }

    public static void resolveFields(Object source, Map<Class<?>, Object> configObjects, Set<Class<?>> restrictTo, Set<Class<?>> skipIf) {
        for (Field field : source.getClass().getDeclaredFields()) {
            for (ConfigurationSettable b : (ConfigurationSettable[])field.getAnnotationsByType(ConfigurationSettable.class)) {
                Method setter;
                Optional<Object> value;
                Object configObject;
                block18: {
                    if (restrictTo != null && !restrictTo.contains(b.configurationClass()) || skipIf != null && skipIf.contains(b.configurationClass())) continue;
                    field.setAccessible(true);
                    configObject = configObjects.get(b.configurationClass());
                    if (configObject == null) continue;
                    String setterName = field.getName();
                    if (!StringUtils.isEmpty((CharSequence)b.methodName())) {
                        setterName = b.methodName();
                    }
                    try {
                        value = field.get(source);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (value == null || ((Object)value).equals(Defaults.defaultValue(field.getType()))) continue;
                    setter = null;
                    if (b.convertToOptional()) {
                        value = Optional.of(value);
                    }
                    if (ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
                        Class primitiveType = field.getType().isPrimitive() ? field.getType() : ClassUtils.wrapperToPrimitive(field.getType());
                        Class wrapperType = !field.getType().isPrimitive() ? field.getType() : ClassUtils.primitiveToWrapper(field.getType());
                        try {
                            setter = b.configurationClass().getMethod(setterName, primitiveType);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (setter == null) {
                            try {
                                setter = b.configurationClass().getMethod(setterName, wrapperType);
                            }
                            catch (NoSuchMethodException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    } else {
                        try {
                            setter = b.configurationClass().getMethod(setterName, value.getClass());
                        }
                        catch (NoSuchMethodException e) {
                            for (Method method : b.configurationClass().getMethods()) {
                                Class<?>[] parameterTypes = method.getParameterTypes();
                                if (!method.getName().equals(setterName) || parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(value.getClass())) continue;
                                setter = method;
                                break;
                            }
                            if (setter != null) break block18;
                            throw new RuntimeException(e);
                        }
                    }
                }
                try {
                    setter.invoke(configObject, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

