/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.multilang.MultiLangDaemonConfig;

public class MultiLangDaemon {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiLangDaemon.class);

    JCommander buildJCommanderAndParseArgs(MultiLangDaemonArguments arguments, String[] args) {
        JCommander jCommander = JCommander.newBuilder().programName("amazon-kinesis-client MultiLangDaemon").addObject((Object)arguments).build();
        jCommander.parse(args);
        return jCommander;
    }

    void printUsage(JCommander jCommander, String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            System.err.println(message);
        }
        jCommander.usage();
    }

    Scheduler buildScheduler(MultiLangDaemonConfig config) {
        return config.getMultiLangDaemonConfiguration().build(config.getRecordProcessorFactory());
    }

    void configureLogging(String logConfiguration) {
        if (StringUtils.isNotEmpty((CharSequence)logConfiguration)) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            this.configureLogging(logConfiguration, loggerContext, configurator);
        }
    }

    void configureLogging(String logConfiguration, LoggerContext loggerContext, JoranConfigurator configurator) {
        loggerContext.reset();
        try (FileInputStream inputStream = FileUtils.openInputStream((File)new File(logConfiguration));){
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure((InputStream)inputStream);
        }
        catch (JoranException | IOException e) {
            throw new RuntimeException("Error while loading log configuration: " + e.getMessage());
        }
    }

    String validateAndGetPropertiesFileName(MultiLangDaemonArguments arguments) {
        String propertiesFile = "";
        if (CollectionUtils.isNotEmpty(arguments.parameters)) {
            if (arguments.parameters.size() == 1) {
                propertiesFile = arguments.parameters.get(0);
            } else {
                throw new RuntimeException("Expected a single argument, but found multiple arguments.  Arguments: " + String.join((CharSequence)", ", arguments.parameters));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)arguments.propertiesFile)) {
            if (StringUtils.isNotEmpty((CharSequence)propertiesFile)) {
                log.warn("Overriding the properties file with the --properties-file option");
            }
            propertiesFile = arguments.propertiesFile;
        }
        if (StringUtils.isEmpty((CharSequence)propertiesFile)) {
            throw new RuntimeException("Properties file missing, please provide a properties file");
        }
        return propertiesFile;
    }

    MultiLangDaemonConfig buildMultiLangDaemonConfig(String propertiesFile) {
        try {
            return new MultiLangDaemonConfig(propertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading properties file: " + e.getMessage());
        }
    }

    void setupShutdownHook(Runtime runtime, MultiLangRunner runner, MultiLangDaemonConfig config) {
        long shutdownGraceMillis = config.getMultiLangDaemonConfiguration().getShutdownGraceMillis();
        runtime.addShutdownHook(new Thread(() -> {
            log.info("Process terminated, will initiate shutdown.");
            try {
                CompletableFuture runnerFuture = runner.scheduler().startGracefulShutdown();
                runnerFuture.get(shutdownGraceMillis, TimeUnit.MILLISECONDS);
                log.info("Process shutdown is complete.");
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error("Encountered an error during shutdown.", (Throwable)e);
            }
        }));
    }

    int submitRunnerAndWait(MultiLangDaemonConfig config, MultiLangRunner runner) {
        ExecutorService executorService = config.getExecutorService();
        Future<Integer> future = executorService.submit(runner);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Encountered an error while running daemon", (Throwable)e);
            return 1;
        }
    }

    void exit(int exitCode) {
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        int exitCode = 1;
        MultiLangDaemon daemon = new MultiLangDaemon();
        MultiLangDaemonArguments arguments = new MultiLangDaemonArguments();
        JCommander jCommander = daemon.buildJCommanderAndParseArgs(arguments, args);
        try {
            String propertiesFileName = daemon.validateAndGetPropertiesFileName(arguments);
            daemon.configureLogging(arguments.logConfiguration);
            MultiLangDaemonConfig config = daemon.buildMultiLangDaemonConfig(propertiesFileName);
            Scheduler scheduler = daemon.buildScheduler(config);
            MultiLangRunner runner = new MultiLangRunner(scheduler);
            daemon.setupShutdownHook(Runtime.getRuntime(), runner, config);
            exitCode = daemon.submitRunnerAndWait(config, runner);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            daemon.printUsage(jCommander, t.getMessage());
            System.err.println("For more information, visit: https://github.com/awslabs/amazon-kinesis-client");
        }
        daemon.exit(exitCode);
    }

    static class MultiLangRunner
    implements Callable<Integer> {
        private final Scheduler scheduler;

        @Override
        public Integer call() throws Exception {
            int exitCode = 0;
            try {
                this.scheduler().run();
            }
            catch (Throwable t) {
                log.error("Caught throwable while processing data", t);
                exitCode = 1;
            }
            return exitCode;
        }

        @Generated
        public MultiLangRunner(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Generated
        public Scheduler scheduler() {
            return this.scheduler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiLangRunner)) {
                return false;
            }
            MultiLangRunner other = (MultiLangRunner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Scheduler this$scheduler = this.scheduler();
            Scheduler other$scheduler = other.scheduler();
            return !(this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MultiLangRunner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Scheduler $scheduler = this.scheduler();
            result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiLangDaemon.MultiLangRunner(scheduler=" + this.scheduler() + ")";
        }
    }

    static class MultiLangDaemonArguments {
        @Parameter
        List<String> parameters = new ArrayList<String>();
        @Parameter(names={"-p", "--properties-file"}, description="Properties file to be used with the KCL")
        String propertiesFile;
        @Parameter(names={"-l", "--log-configuration"}, description="File location of logback.xml to be override the default")
        String logConfiguration;

        MultiLangDaemonArguments() {
        }
    }
}

