/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LineReaderTask<T>
implements Callable<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineReaderTask.class);
    private BufferedReader reader;
    private String description;
    private String shardId;

    LineReaderTask() {
    }

    @Override
    public T call() throws Exception {
        String nextLine = null;
        try {
            log.info("Starting: {}", (Object)this.description);
            while ((nextLine = this.reader.readLine()) != null) {
                HandleLineResult<T> result = this.handleLine(nextLine);
                if (!result.hasReturnValue()) continue;
                return result.returnValue();
            }
        }
        catch (IOException e) {
            return this.returnAfterException(e);
        }
        log.info("Stopping: {}", (Object)this.description);
        return this.returnAfterEndOfInput();
    }

    protected abstract HandleLineResult<T> handleLine(String var1);

    protected abstract T returnAfterException(Exception var1) throws Exception;

    protected abstract T returnAfterEndOfInput();

    public String getShardId() {
        return this.shardId;
    }

    public String getDescription() {
        return this.description;
    }

    protected LineReaderTask<T> initialize(InputStream stream, String shardId, String description) {
        return this.initialize(new BufferedReader(new InputStreamReader(stream)), shardId, description);
    }

    protected LineReaderTask<T> initialize(BufferedReader reader, String shardId, String description) {
        this.reader = reader;
        this.shardId = shardId;
        this.description = description;
        return this;
    }

    protected class HandleLineResult<V> {
        private boolean hasReturnValue;
        private V returnValue;

        HandleLineResult() {
            this.hasReturnValue = false;
        }

        HandleLineResult(V returnValue) {
            this.hasReturnValue = true;
            this.returnValue = returnValue;
        }

        boolean hasReturnValue() {
            return this.hasReturnValue;
        }

        V returnValue() {
            if (this.hasReturnValue()) {
                return this.returnValue;
            }
            throw new RuntimeException("There was no value to return.");
        }
    }
}

