/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.multilang.config.MultiLangDaemonConfiguration;
import software.amazon.kinesis.multilang.config.RetrievalConfigBuilder;

public enum RetrievalMode {
    FANOUT(MultiLangDaemonConfiguration::getFanoutConfig),
    POLLING(MultiLangDaemonConfiguration::getPollingConfig),
    DEFAULT(RetrievalMode::decideForDefault);

    private static final Logger log;
    private final Function<MultiLangDaemonConfiguration, RetrievalConfigBuilder> builderFor;

    public RetrievalConfigBuilder builder(MultiLangDaemonConfiguration configuration) {
        return this.builderFor.apply(configuration);
    }

    private RetrievalMode(Function<MultiLangDaemonConfiguration, RetrievalConfigBuilder> builderFor) {
        this.builderFor = builderFor;
    }

    public static RetrievalMode from(String source) {
        Validate.notEmpty((CharSequence)source);
        try {
            return RetrievalMode.valueOf(source.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown retrieval type '" + source + "'. Available retrieval types: " + RetrievalMode.availableRetrievalModes());
        }
    }

    private static String availableRetrievalModes() {
        return "(" + Arrays.stream(RetrievalMode.values()).map(Enum::name).collect(Collectors.joining(", ")) + ")";
    }

    private static RetrievalConfigBuilder decideForDefault(MultiLangDaemonConfiguration configuration) {
        if (configuration.getPollingConfig().anyPropertiesSet()) {
            log.warn("Some polling properties have been set, defaulting to polling. To switch to Fanout either add `RetrievalMode=FANOUT` to your properties or remove the any configuration for polling.");
            return configuration.getPollingConfig();
        }
        return configuration.getFanoutConfig();
    }

    static {
        log = LoggerFactory.getLogger(RetrievalMode.class);
    }
}

